/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.NameBound;
import org.glassfish.jersey.model.internal.ProviderBag;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodConfig;
import org.glassfish.jersey.server.model.internal.ResourceMethodDispatcherFactory;
import org.glassfish.jersey.server.model.internal.ResourceMethodInvocationHandlerFactory;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

public class ResourceMethodInvoker
implements Endpoint,
ResourceInfo {
    private final Provider<RoutingContext> routingContextProvider;
    private final Provider<AsyncContext> asyncContextProvider;
    private final Provider<RespondingContext> respondingContextProvider;
    private final ResourceMethod method;
    private final ResourceMethodDispatcher dispatcher;
    private final Method resourceMethod;
    private final Class<?> resourceClass;
    private final List<RankedProvider<ContainerRequestFilter>> requestFilters = Lists.newArrayList();
    private final List<RankedProvider<ContainerResponseFilter>> responseFilters = Lists.newArrayList();
    private final List<RankedProvider<ReaderInterceptor>> readerInterceptors;
    private final List<RankedProvider<WriterInterceptor>> writerInterceptors;

    private ResourceMethodInvoker(Provider<RoutingContext> routingContextProvider, Provider<AsyncContext> asyncContextProvider, Provider<RespondingContext> respondingContextProvider, ResourceMethodDispatcher.Provider dispatcherProvider, ResourceMethodInvocationHandlerProvider invocationHandlerProvider, ResourceMethod method, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerRequestFilter>> nameBoundRequestFilters, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerResponseFilter>> nameBoundResponseFilters, Iterable<RankedProvider<ReaderInterceptor>> globalReaderInterceptors, Iterable<RankedProvider<WriterInterceptor>> globalWriterInterceptors, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ReaderInterceptor>> nameBoundReaderInterceptors, MultivaluedMap<Class<? extends Annotation>, RankedProvider<WriterInterceptor>> nameBoundWriterInterceptors, Iterable<DynamicFeature> dynamicFeatures, ServiceLocator locator, Configurable globalConfig) {
        this.routingContextProvider = routingContextProvider;
        this.asyncContextProvider = asyncContextProvider;
        this.respondingContextProvider = respondingContextProvider;
        this.method = method;
        Invocable invocable = method.getInvocable();
        this.dispatcher = dispatcherProvider.create(invocable, invocationHandlerProvider.create(invocable));
        this.resourceMethod = invocable.getHandlingMethod();
        this.resourceClass = invocable.getHandler().getHandlerClass();
        final ResourceMethodConfig config = new ResourceMethodConfig(globalConfig.getProperties());
        for (DynamicFeature dynamicFeature : dynamicFeatures) {
            dynamicFeature.configure((ResourceInfo)this, (Configurable)config);
        }
        ProviderBag providerBag = config.getProviderBag();
        ArrayList providers = Lists.newArrayList((Iterable)providerBag.getInstances());
        if (!providerBag.getClasses().isEmpty()) {
            locator = Injections.createLocator((ServiceLocator)locator, (Binder[])new Binder[]{new AbstractBinder(){

                protected void configure() {
                    this.bind((Object)config).to(Configurable.class);
                }
            }});
            for (Class providerClass : providerBag.getClasses()) {
                providers.add(locator.create(providerClass));
            }
        }
        LinkedList _readerInterceptors = Lists.newLinkedList();
        LinkedList _writerInterceptors = Lists.newLinkedList();
        LinkedList _requestFilters = Lists.newLinkedList();
        LinkedList _responseFilters = Lists.newLinkedList();
        Map models = providerBag.getModels();
        for (Object provider : providers) {
            ContractProvider model = (ContractProvider)models.get(provider.getClass());
            Set contracts = model.getContracts();
            if (contracts.contains(WriterInterceptor.class)) {
                _writerInterceptors.add(new RankedProvider((Object)((WriterInterceptor)provider), model.getPriority(WriterInterceptor.class)));
            }
            if (contracts.contains(ReaderInterceptor.class)) {
                _readerInterceptors.add(new RankedProvider((Object)((ReaderInterceptor)provider), model.getPriority(ReaderInterceptor.class)));
            }
            if (contracts.contains(ContainerRequestFilter.class)) {
                _requestFilters.add(new RankedProvider((Object)((ContainerRequestFilter)provider), model.getPriority(ContainerRequestFilter.class)));
            }
            if (!contracts.contains(ContainerResponseFilter.class)) continue;
            _responseFilters.add(new RankedProvider((Object)((ContainerResponseFilter)provider), model.getPriority(ContainerResponseFilter.class)));
        }
        _readerInterceptors.addAll(Lists.newLinkedList(globalReaderInterceptors));
        _writerInterceptors.addAll(Lists.newLinkedList(globalWriterInterceptors));
        if (this.resourceMethod != null) {
            this.addNameBoundFiltersAndInterceptors(nameBoundRequestFilters, nameBoundResponseFilters, nameBoundReaderInterceptors, nameBoundWriterInterceptors, _requestFilters, _responseFilters, _readerInterceptors, _writerInterceptors, method);
        }
        this.readerInterceptors = _readerInterceptors;
        this.writerInterceptors = _writerInterceptors;
        this.requestFilters.addAll(_requestFilters);
        this.responseFilters.addAll(_responseFilters);
    }

    private void addNameBoundFiltersAndInterceptors(MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerRequestFilter>> nameBoundRequestFilters, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerResponseFilter>> nameBoundResponseFilters, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ReaderInterceptor>> nameBoundReaderInterceptors, MultivaluedMap<Class<? extends Annotation>, RankedProvider<WriterInterceptor>> nameBoundWriterInterceptors, Collection<RankedProvider<ContainerRequestFilter>> targetRequestFilters, Collection<RankedProvider<ContainerResponseFilter>> targetResponseFilters, Collection<RankedProvider<ReaderInterceptor>> targetReaderInterceptors, Collection<RankedProvider<WriterInterceptor>> targetWriterInterceptors, NameBound target) {
        for (Class nameBinding : target.getNameBindings()) {
            Iterable _writerInterceptors;
            Iterable _readerInterceptors;
            Iterable resF;
            Iterable reqF = (Iterable)nameBoundRequestFilters.get((Object)nameBinding);
            if (reqF != null) {
                targetRequestFilters.addAll(Lists.newLinkedList((Iterable)reqF));
            }
            if ((resF = (Iterable)nameBoundResponseFilters.get((Object)nameBinding)) != null) {
                targetResponseFilters.addAll(Lists.newLinkedList((Iterable)resF));
            }
            if ((_readerInterceptors = (Iterable)nameBoundReaderInterceptors.get((Object)nameBinding)) != null) {
                targetReaderInterceptors.addAll(Lists.newLinkedList((Iterable)_readerInterceptors));
            }
            if ((_writerInterceptors = (Iterable)nameBoundWriterInterceptors.get((Object)nameBinding)) == null) continue;
            targetWriterInterceptors.addAll(Lists.newLinkedList((Iterable)_writerInterceptors));
        }
    }

    public Method getResourceMethod() {
        return this.resourceMethod;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public ContainerResponse apply(final ContainerRequest requestContext) {
        final Object resource = ((RoutingContext)this.routingContextProvider.get()).peekMatchedResource();
        requestContext.setProperty("jersey.runtime.reader.interceptors", Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{this.getReaderInterceptors()}));
        requestContext.setProperty("jersey.runtime.writer.interceptors", Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{this.getWriterInterceptors()}));
        if (this.method.isSuspendDeclared() || this.method.isManagedAsyncDeclared()) {
            ((AsyncContext)this.asyncContextProvider.get()).suspend();
        }
        if (this.method.isManagedAsyncDeclared()) {
            ((AsyncContext)this.asyncContextProvider.get()).invokeManaged(new Producer<Response>(){

                public Response call() {
                    Response response = ResourceMethodInvoker.this.invoke(requestContext, resource);
                    if (ResourceMethodInvoker.this.method.isSuspendDeclared()) {
                        return null;
                    }
                    return response;
                }
            });
            return null;
        }
        return new ContainerResponse(requestContext, this.invoke(requestContext, resource));
    }

    private Response invoke(ContainerRequest requestContext, Object resource) {
        Response jaxrsResponse = this.dispatcher.dispatch(resource, requestContext);
        ((RespondingContext)this.respondingContextProvider.get()).push(new Function<ContainerResponse, ContainerResponse>(){

            public ContainerResponse apply(ContainerResponse response) {
                Type invocableType;
                if (response == null) {
                    return response;
                }
                Invocable invocable = ResourceMethodInvoker.this.method.getInvocable();
                Annotation[] entityAnn = response.getEntityAnnotations();
                Annotation[] methodAnn = invocable.getHandlingMethod().getDeclaredAnnotations();
                if (methodAnn.length > 0) {
                    if (entityAnn.length == 0) {
                        response.setEntityAnnotations(methodAnn);
                    } else {
                        Annotation[] mergedAnn = Arrays.copyOf(methodAnn, methodAnn.length + entityAnn.length);
                        System.arraycopy(entityAnn, 0, mergedAnn, methodAnn.length, entityAnn.length);
                        response.setEntityAnnotations(mergedAnn);
                    }
                }
                if (response.hasEntity() && !(response.getEntityType() instanceof ParameterizedType) && (invocableType = invocable.getResponseType()) != null && Void.TYPE != invocableType && Void.class != invocableType && Response.class != invocableType) {
                    response.setEntityType(invocableType);
                }
                return response;
            }
        });
        return jaxrsResponse;
    }

    public Iterable<RankedProvider<ContainerRequestFilter>> getRequestFilters() {
        return this.requestFilters;
    }

    public Iterable<RankedProvider<ContainerResponseFilter>> getResponseFilters() {
        return this.responseFilters;
    }

    public Iterable<RankedProvider<WriterInterceptor>> getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public Iterable<RankedProvider<ReaderInterceptor>> getReaderInterceptors() {
        return this.readerInterceptors;
    }

    public String toString() {
        return this.method.getInvocable().getHandlingMethod().toString();
    }

    public static class Builder {
        @Inject
        private Provider<RoutingContext> routingContextProvider;
        @Inject
        private Provider<AsyncContext> asyncContextProvider;
        @Inject
        private Provider<RespondingContext> respondingContextProvider;
        @Inject
        private ResourceMethodDispatcherFactory dispatcherProviderFactory;
        @Inject
        private ResourceMethodInvocationHandlerFactory invocationHandlerProviderFactory;
        @Inject
        private ServiceLocator locator;
        @Inject
        private Configurable globalConfig;

        public ResourceMethodInvoker build(ResourceMethod method, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerRequestFilter>> nameBoundRequestFilters, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ContainerResponseFilter>> nameBoundResponseFilters, Iterable<RankedProvider<ReaderInterceptor>> globalReaderInterceptors, Iterable<RankedProvider<WriterInterceptor>> globalWriterInterceptors, MultivaluedMap<Class<? extends Annotation>, RankedProvider<ReaderInterceptor>> nameBoundReaderInterceptors, MultivaluedMap<Class<? extends Annotation>, RankedProvider<WriterInterceptor>> nameBoundWriterInterceptors, Iterable<DynamicFeature> dynamicFeatures) {
            return new ResourceMethodInvoker(this.routingContextProvider, this.asyncContextProvider, this.respondingContextProvider, this.dispatcherProviderFactory, this.invocationHandlerProviderFactory, method, nameBoundRequestFilters, nameBoundResponseFilters, globalReaderInterceptors, globalWriterInterceptors, nameBoundReaderInterceptors, nameBoundWriterInterceptors, dynamicFeatures, this.locator, this.globalConfig);
        }
    }
}

