/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.wadl.internal;

import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.ParamStyle;
import com.sun.research.ws.wadl.Representation;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.wadl.WadlGenerator;
import org.glassfish.jersey.server.wadl.internal.ApplicationDescription;
import org.glassfish.jersey.server.wadl.internal.generators.WadlGeneratorJAXBGrammarGenerator;

public class WadlBuilder {
    private WadlGenerator _wadlGenerator;

    public WadlBuilder() {
        this(new WadlGeneratorJAXBGrammarGenerator());
    }

    public WadlBuilder(WadlGenerator wadlGenerator) {
        this._wadlGenerator = wadlGenerator;
    }

    public ApplicationDescription generate(List<org.glassfish.jersey.server.model.Resource> resources) {
        Application wadlApplication = this._wadlGenerator.createApplication();
        Resources wadlResources = this._wadlGenerator.createResources();
        for (org.glassfish.jersey.server.model.Resource r : resources) {
            Resource wadlResource = this.generateResource(r, null);
            wadlResources.getResource().add(wadlResource);
        }
        wadlApplication.getResources().add(wadlResources);
        this.addVersion(wadlApplication);
        WadlGenerator.ExternalGrammarDefinition external = this._wadlGenerator.createExternalGrammar();
        ApplicationDescription description = new ApplicationDescription(wadlApplication, external);
        this._wadlGenerator.attachTypes(description);
        return description;
    }

    public Application generate(ApplicationDescription description, org.glassfish.jersey.server.model.Resource resource) {
        Application wadlApplication = this._wadlGenerator.createApplication();
        Resources wadlResources = this._wadlGenerator.createResources();
        Resource wadlResource = this.generateResource(resource, null);
        wadlResources.getResource().add(wadlResource);
        wadlApplication.getResources().add(wadlResources);
        this.addVersion(wadlApplication);
        this._wadlGenerator.attachTypes(description);
        return wadlApplication;
    }

    public Application generate(ApplicationDescription description, org.glassfish.jersey.server.model.Resource resource, String path) {
        Application wadlApplication = this._wadlGenerator.createApplication();
        Resources wadlResources = this._wadlGenerator.createResources();
        Resource wadlResource = this.generateSubResource(resource, path);
        wadlResources.getResource().add(wadlResource);
        wadlApplication.getResources().add(wadlResources);
        this.addVersion(wadlApplication);
        this._wadlGenerator.attachTypes(description);
        return wadlApplication;
    }

    private void addVersion(Application wadlApplication) {
        Doc d = new Doc();
        d.getOtherAttributes().put(new QName("http://jersey.java.net/", "generatedBy", "jersey"), Version.getBuildId());
        wadlApplication.getDoc().add(0, d);
    }

    private Method generateMethod(org.glassfish.jersey.server.model.Resource r, Map<String, Param> wadlResourceParams, ResourceMethod m) {
        List<Response> responses;
        Method wadlMethod = this._wadlGenerator.createMethod(r, m);
        Request wadlRequest = this.generateRequest(r, m, wadlResourceParams);
        if (wadlRequest != null) {
            wadlMethod.setRequest(wadlRequest);
        }
        if ((responses = this.generateResponses(r, m)) != null) {
            wadlMethod.getResponse().addAll(responses);
        }
        return wadlMethod;
    }

    private Request generateRequest(org.glassfish.jersey.server.model.Resource r, ResourceMethod m, Map<String, Param> wadlResourceParams) {
        if (m.getInvocable().getParameters().isEmpty()) {
            return null;
        }
        Request wadlRequest = this._wadlGenerator.createRequest(r, m);
        for (Parameter p : m.getInvocable().getParameters()) {
            Param wadlParam;
            Representation wadlRepresentation;
            List<MediaType> supportedInputTypes;
            if (p.getSource() == Parameter.Source.ENTITY) {
                for (MediaType mediaType : m.getConsumedTypes()) {
                    this.setRepresentationForMediaType(r, m, mediaType, wadlRequest);
                }
                continue;
            }
            if (p.getAnnotation().annotationType() == FormParam.class) {
                supportedInputTypes = m.getConsumedTypes();
                if (supportedInputTypes.isEmpty() || supportedInputTypes.size() == 1 && supportedInputTypes.get(0).isWildcardType()) {
                    supportedInputTypes = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
                }
                for (MediaType mediaType : supportedInputTypes) {
                    wadlRepresentation = this.setRepresentationForMediaType(r, m, mediaType, wadlRequest);
                    if (this.getParamByName(wadlRepresentation.getParam(), p.getSourceName()) != null || (wadlParam = this.generateParam(r, m, p)) == null) continue;
                    wadlRepresentation.getParam().add(wadlParam);
                }
                continue;
            }
            if (p.getAnnotation().annotationType().getName().equals("org.glassfish.jersey.media.multipart.FormDataParam")) {
                supportedInputTypes = m.getConsumedTypes();
                if (supportedInputTypes.isEmpty() || supportedInputTypes.size() == 1 && supportedInputTypes.get(0).isWildcardType()) {
                    supportedInputTypes = Collections.singletonList(MediaType.MULTIPART_FORM_DATA_TYPE);
                }
                for (MediaType mediaType : supportedInputTypes) {
                    wadlRepresentation = this.setRepresentationForMediaType(r, m, mediaType, wadlRequest);
                    if (this.getParamByName(wadlRepresentation.getParam(), p.getSourceName()) != null || (wadlParam = this.generateParam(r, m, p)) == null) continue;
                    wadlRepresentation.getParam().add(wadlParam);
                }
                continue;
            }
            Param wadlParam2 = this.generateParam(r, m, p);
            if (wadlParam2 == null) continue;
            if (wadlParam2.getStyle() == ParamStyle.TEMPLATE || wadlParam2.getStyle() == ParamStyle.MATRIX) {
                wadlResourceParams.put(wadlParam2.getName(), wadlParam2);
                continue;
            }
            wadlRequest.getParam().add(wadlParam2);
        }
        if (wadlRequest.getRepresentation().size() + wadlRequest.getParam().size() == 0) {
            return null;
        }
        return wadlRequest;
    }

    private Param getParamByName(List<Param> params, String name) {
        for (Param param : params) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    private Representation setRepresentationForMediaType(org.glassfish.jersey.server.model.Resource r, ResourceMethod m, MediaType mediaType, Request wadlRequest) {
        Representation wadlRepresentation = this.getRepresentationByMediaType(wadlRequest.getRepresentation(), mediaType);
        if (wadlRepresentation == null) {
            wadlRepresentation = this._wadlGenerator.createRequestRepresentation(r, m, mediaType);
            wadlRequest.getRepresentation().add(wadlRepresentation);
        }
        return wadlRepresentation;
    }

    private Representation getRepresentationByMediaType(List<Representation> representations, MediaType mediaType) {
        for (Representation representation : representations) {
            if (!mediaType.toString().equals(representation.getMediaType())) continue;
            return representation;
        }
        return null;
    }

    private Param generateParam(org.glassfish.jersey.server.model.Resource r, ResourceMethod m, Parameter p) {
        if (p.getSource() == Parameter.Source.ENTITY || p.getSource() == Parameter.Source.CONTEXT) {
            return null;
        }
        return this._wadlGenerator.createParam(r, m, p);
    }

    private Resource generateResource(org.glassfish.jersey.server.model.Resource r, String path) {
        return this.generateResource(r, path, Collections.<org.glassfish.jersey.server.model.Resource>emptySet());
    }

    private Resource generateResource(org.glassfish.jersey.server.model.Resource r, String path, Set<org.glassfish.jersey.server.model.Resource> visitedResources) {
        HashMap wadlSubResourceParams;
        Resource wadlSubResource;
        String template;
        Resource wadlResource = this._wadlGenerator.createResource(r, path);
        if (visitedResources.contains(r)) {
            return wadlResource;
        }
        visitedResources = new HashSet<org.glassfish.jersey.server.model.Resource>(visitedResources);
        visitedResources.add(r);
        HashMap<String, Param> wadlResourceParams = new HashMap<String, Param>();
        LinkedList fieldsOrSetters = new LinkedList();
        for (Parameterized f : fieldsOrSetters) {
            for (Parameter parameter : f.getParameters()) {
                Param wadlParam = this.generateParam(r, null, parameter);
                if (wadlParam == null) continue;
                wadlResource.getParam().add(wadlParam);
            }
        }
        for (ResourceMethod m : r.getResourceMethods()) {
            Method wadlMethod = this.generateMethod(r, wadlResourceParams, m);
            wadlResource.getMethodOrResource().add(wadlMethod);
        }
        for (Param wadlParam : wadlResourceParams.values()) {
            wadlResource.getParam().add(wadlParam);
        }
        HashMap<String, Resource> wadlSubResources = new HashMap<String, Resource>();
        HashMap wadlSubResourcesParams = new HashMap();
        for (ResourceMethod resourceMethod : r.getSubResourceMethods()) {
            template = resourceMethod.getPath();
            wadlSubResource = (Resource)wadlSubResources.get(template);
            wadlSubResourceParams = (HashMap)wadlSubResourcesParams.get(template);
            if (wadlSubResource == null) {
                wadlSubResource = new Resource();
                wadlSubResource.setPath(template);
                wadlSubResources.put(template, wadlSubResource);
                wadlSubResourceParams = new HashMap();
                wadlSubResourcesParams.put(template, wadlSubResourceParams);
                wadlResource.getMethodOrResource().add(wadlSubResource);
            }
            Method wadlMethod = this.generateMethod(r, wadlSubResourceParams, resourceMethod);
            wadlSubResource.getMethodOrResource().add(wadlMethod);
        }
        for (Map.Entry entry : wadlSubResources.entrySet()) {
            template = (String)entry.getKey();
            wadlSubResource = (Resource)entry.getValue();
            wadlSubResourceParams = (Map)wadlSubResourcesParams.get(template);
            for (Param wadlParam : wadlSubResourceParams.values()) {
                wadlSubResource.getParam().add(wadlParam);
            }
        }
        for (ResourceMethod resourceMethod : r.getSubResourceLocators()) {
            Resource.Builder builder = org.glassfish.jersey.server.model.Resource.builder(resourceMethod.getInvocable().getRawResponseType());
            if (builder == null) {
                builder = org.glassfish.jersey.server.model.Resource.builder().path(resourceMethod.getPath());
            }
            org.glassfish.jersey.server.model.Resource subResource = builder.build();
            Resource wadlSubResource2 = this.generateResource(subResource, resourceMethod.getPath(), visitedResources);
            wadlResource.getMethodOrResource().add(wadlSubResource2);
            for (Parameter p : resourceMethod.getInvocable().getParameters()) {
                Param wadlParam = this.generateParam(r, resourceMethod, p);
                if (wadlParam == null || wadlParam.getStyle() != ParamStyle.TEMPLATE) continue;
                wadlSubResource2.getParam().add(wadlParam);
            }
        }
        return wadlResource;
    }

    private Resource generateSubResource(org.glassfish.jersey.server.model.Resource r, String path) {
        Resource wadlResource = new Resource();
        if (r.isRootResource()) {
            StringBuilder b = new StringBuilder(r.getPath());
            if (!r.getPath().endsWith("/") && !path.startsWith("/")) {
                b.append("/");
            }
            b.append(path);
            wadlResource.setPath(b.toString());
        }
        HashMap<String, Param> wadlSubResourceParams = new HashMap<String, Param>();
        for (ResourceMethod m : r.getSubResourceMethods()) {
            String template = m.getPath();
            if (!template.equals(path) && !template.equals('/' + path)) continue;
            Method wadlMethod = this.generateMethod(r, wadlSubResourceParams, m);
            wadlResource.getMethodOrResource().add(wadlMethod);
        }
        for (Param wadlParam : wadlSubResourceParams.values()) {
            wadlResource.getParam().add(wadlParam);
        }
        return wadlResource;
    }

    private List<Response> generateResponses(org.glassfish.jersey.server.model.Resource r, ResourceMethod m) {
        if (m.getInvocable().getRawResponseType() == Void.TYPE) {
            return null;
        }
        return this._wadlGenerator.createResponses(r, m);
    }
}

