/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.IntrospectionModeller;
import org.glassfish.jersey.server.model.MethodHandler;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.Routed;
import org.glassfish.jersey.uri.PathPattern;

public final class Resource
implements Routed,
ResourceModelComponent {
    private final List<String> names;
    private transient String name;
    private final String path;
    private final PathPattern pathPattern;
    private final boolean isRoot;
    private final List<ResourceMethod> resourceMethods;
    private final ResourceMethod subResourceLocator;
    private final List<Resource> childResources;
    private final Set<Class<?>> handlerClasses;
    private final Set<Object> handlerInstances;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String path) {
        return new Builder(path);
    }

    public static Builder builder(Class<?> resourceClass) throws IllegalArgumentException {
        Builder builder = new IntrospectionModeller(resourceClass).createResourceBuilder();
        return builder.isEmpty() ? null : builder;
    }

    public static Resource from(Class<?> resourceClass) throws IllegalArgumentException {
        Builder builder = new IntrospectionModeller(resourceClass).createResourceBuilder();
        return builder.isEmpty() ? null : builder.build();
    }

    public static boolean isAcceptable(Class<?> c) {
        return (c.getModifiers() & 0x400) == 0 && !c.isPrimitive() && !c.isAnnotation() && !c.isInterface() && !c.isLocalClass() && (!c.isMemberClass() || (c.getModifiers() & 8) != 0);
    }

    public static Path getPath(Class<?> resourceClass) {
        return IntrospectionModeller.getAnnotatedResourceClass(resourceClass).getAnnotation(Path.class);
    }

    public static Builder builder(Resource resource) {
        Builder b = new Builder(resource.path);
        b.resourceMethods.addAll(resource.resourceMethods);
        b.childResources.addAll(resource.getChildResources());
        b.resourceLocator = resource.subResourceLocator;
        b.handlerClasses.addAll(resource.handlerClasses);
        b.handlerInstances.addAll(resource.handlerInstances);
        return b;
    }

    private Resource(List<String> names, String path, boolean isRoot, boolean isChild, List<ResourceMethod> resourceMethods, ResourceMethod subResourceLocator, List<Resource> childResources, Set<Class<?>> handlerClasses, Set<Object> handlerInstances) {
        this.names = names;
        this.path = path;
        this.isRoot = !isChild && isRoot;
        this.pathPattern = path == null || path.isEmpty() ? PathPattern.OPEN_ROOT_PATH_PATTERN : new PathPattern(path, PathPattern.RightHandPath.capturingZeroOrMoreSegments);
        this.resourceMethods = resourceMethods;
        this.subResourceLocator = subResourceLocator;
        this.childResources = childResources;
        this.handlerClasses = handlerClasses;
        this.handlerInstances = handlerInstances;
    }

    public boolean isRootResource() {
        return this.isRoot;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public PathPattern getPathPattern() {
        return this.pathPattern;
    }

    public String getName() {
        if (this.name == null) {
            if (this.names.size() == 1) {
                this.name = this.names.get(0);
            } else {
                StringBuilder nameBuilder = new StringBuilder("Merge of ");
                nameBuilder.append(this.names.toString());
                this.name = nameBuilder.toString();
            }
        }
        return this.name;
    }

    public List<ResourceMethod> getResourceMethods() {
        return this.resourceMethods;
    }

    public ResourceMethod getResourceLocator() {
        return this.subResourceLocator;
    }

    public List<ResourceMethod> getAllMethods() {
        LinkedList methodsAndLocators = Lists.newLinkedList(this.resourceMethods);
        if (this.subResourceLocator != null) {
            methodsAndLocators.add(this.subResourceLocator);
        }
        return methodsAndLocators;
    }

    public List<Resource> getChildResources() {
        return this.childResources;
    }

    public Set<Class<?>> getHandlerClasses() {
        return this.handlerClasses;
    }

    public Set<Object> getHandlerInstances() {
        return this.handlerInstances;
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitResource(this);
    }

    public String toString() {
        return "Resource {" + (this.path == null ? "[unbound], " : "\"" + this.path + "\", ") + this.childResources.size() + " child resources," + this.resourceMethods.size() + " resource methods, " + (this.subResourceLocator == null ? "0" : "1") + " sub-resource locators, " + this.handlerClasses.size() + " method handler classes, " + this.handlerInstances.size() + " method handler instances" + '}';
    }

    @Override
    public List<? extends ResourceModelComponent> getComponents() {
        LinkedList<ResourceModelComponent> components = new LinkedList<ResourceModelComponent>();
        components.addAll(Lists.transform(this.getChildResources(), (Function)new Function<Resource, ChildResourceComponent>(){

            public ChildResourceComponent apply(Resource childResource) {
                return new ChildResourceComponent(childResource);
            }
        }));
        Resource.addResourceCommonComponents(this, components);
        return components;
    }

    private static void addResourceCommonComponents(Resource resource, List<ResourceModelComponent> components) {
        components.addAll(resource.getResourceMethods());
        if (resource.getResourceLocator() != null) {
            components.add(resource.getResourceLocator());
        }
    }

    private static class ChildResourceComponent
    implements ResourceModelComponent {
        private final Resource childResource;

        private ChildResourceComponent(Resource childResource) {
            this.childResource = childResource;
        }

        @Override
        public void accept(ResourceModelVisitor visitor) {
            visitor.visitChildResource(this.childResource);
        }

        @Override
        public List<? extends ResourceModelComponent> getComponents() {
            LinkedList components = new LinkedList();
            Resource.addResourceCommonComponents(this.childResource, components);
            return components;
        }
    }

    public static final class Builder {
        private List<String> names;
        private String path;
        private boolean isRoot;
        private final Set<ResourceMethod.Builder> methodBuilders = Sets.newIdentityHashSet();
        private final Set<Builder> childResourceBuilders = Sets.newIdentityHashSet();
        private final List<Resource> childResources = Lists.newLinkedList();
        private final List<ResourceMethod> resourceMethods = Lists.newLinkedList();
        private ResourceMethod resourceLocator;
        private final Set<Class<?>> handlerClasses = Sets.newIdentityHashSet();
        private final Set<Object> handlerInstances = Sets.newIdentityHashSet();
        private final Builder parentResource;

        private Builder(Builder parentResource) {
            this.parentResource = parentResource;
            this.name("[unnamed]");
        }

        private Builder(String path) {
            this((Builder)null);
            this.path(path);
        }

        private Builder(String path, Builder parentResource) {
            this(parentResource);
            this.path = path;
        }

        private Builder() {
            this((Builder)null);
        }

        private boolean isEmpty() {
            return !this.isRoot && this.methodBuilders.isEmpty() && this.childResourceBuilders.isEmpty() && this.resourceMethods.isEmpty() && this.childResources.isEmpty() && this.resourceLocator == null;
        }

        public Builder name(String name) {
            this.names = Lists.newArrayList((Object[])new String[]{name});
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.isRoot = true;
            return this;
        }

        public ResourceMethod.Builder addMethod(String httpMethod) {
            ResourceMethod.Builder builder = new ResourceMethod.Builder(this);
            this.methodBuilders.add(builder);
            return builder.httpMethod(httpMethod);
        }

        public ResourceMethod.Builder addMethod() {
            ResourceMethod.Builder builder = new ResourceMethod.Builder(this);
            this.methodBuilders.add(builder);
            return builder;
        }

        public Builder addChildResource(String relativePath) {
            if (this.parentResource != null) {
                throw new IllegalStateException(LocalizationMessages.RESOURCE_ADD_CHILD_ALREADY_CHILD());
            }
            Builder resourceBuilder = new Builder(relativePath, this);
            this.childResourceBuilders.add(resourceBuilder);
            return resourceBuilder;
        }

        public void addChildResource(Resource resource) {
            this.childResources.add(resource);
        }

        public Builder mergeWith(final Resource resource) {
            this.resourceMethods.addAll(resource.getResourceMethods());
            this.childResources.addAll(resource.childResources);
            if (this.resourceLocator != null && resource.subResourceLocator != null) {
                Errors.processWithException((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Errors.error((Object)this, (String)LocalizationMessages.RESOURCE_MERGE_CONFLICT_LOCATORS(Builder.this, resource, Builder.this.path), (boolean)true);
                    }
                });
            } else if (resource.subResourceLocator != null) {
                this.resourceLocator = resource.subResourceLocator;
            }
            this.handlerClasses.addAll(resource.getHandlerClasses());
            this.handlerInstances.addAll(resource.getHandlerInstances());
            this.names.addAll(resource.names);
            return this;
        }

        public Builder mergeWith(final Builder resourceBuilder) {
            resourceBuilder.processMethodBuilders();
            this.resourceMethods.addAll(resourceBuilder.resourceMethods);
            this.childResources.addAll(resourceBuilder.childResources);
            if (this.resourceLocator != null && resourceBuilder.resourceLocator != null) {
                Errors.processWithException((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Errors.warning((Object)this, (String)LocalizationMessages.RESOURCE_MERGE_CONFLICT_LOCATORS(Builder.this, resourceBuilder, Builder.this.path));
                    }
                });
            } else if (resourceBuilder.resourceLocator != null) {
                this.resourceLocator = resourceBuilder.resourceLocator;
            }
            this.handlerClasses.addAll(resourceBuilder.handlerClasses);
            this.handlerInstances.addAll(resourceBuilder.handlerInstances);
            this.names.addAll(resourceBuilder.names);
            return this;
        }

        void onBuildMethod(ResourceMethod.Builder builder, ResourceMethod method) {
            Preconditions.checkState((boolean)this.methodBuilders.remove(builder), (Object)"Resource.Builder.onBuildMethod() invoked from a resource method builder that is not registered in the resource builder instance.");
            switch (method.getType()) {
                case RESOURCE_METHOD: {
                    this.resourceMethods.add(method);
                    break;
                }
                case SUB_RESOURCE_LOCATOR: {
                    if (this.resourceLocator != null) {
                        Errors.processWithException((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Errors.error((Object)this, (String)LocalizationMessages.AMBIGUOUS_SRLS(this, Builder.this.path), (boolean)true);
                            }
                        });
                    }
                    this.resourceLocator = method;
                }
            }
            MethodHandler methodHandler = method.getInvocable().getHandler();
            if (methodHandler.isClassBased()) {
                this.handlerClasses.add(methodHandler.getHandlerClass());
            } else {
                this.handlerInstances.add(methodHandler.getHandlerInstance());
            }
        }

        private void onBuildChildResource(Builder childResourceBuilder, Resource childResource) {
            Preconditions.checkState((boolean)this.childResourceBuilders.remove(childResourceBuilder), (Object)"Resource.Builder.onBuildChildResource() invoked from a resource builder that is not registered in the resource builder instance as a child resource builder.");
            this.childResources.add(childResource);
        }

        private List<Resource> mergeResources(List<Resource> resources) {
            ArrayList mergedResources = Lists.newArrayList();
            for (int i = 0; i < resources.size(); ++i) {
                Resource outer = resources.get(i);
                Builder builder = null;
                for (int j = i + 1; j < resources.size(); ++j) {
                    Resource inner = resources.get(j);
                    if (!outer.getPath().equals(inner.getPath())) continue;
                    if (builder == null) {
                        builder = Resource.builder(outer);
                    }
                    builder.mergeWith(inner);
                    resources.remove(j);
                    --j;
                }
                if (builder == null) {
                    mergedResources.add(outer);
                    continue;
                }
                mergedResources.add(builder.build());
            }
            return mergedResources;
        }

        public Resource build() {
            this.processMethodBuilders();
            this.processChildResourceBuilders();
            Resource resource = new Resource(Builder.immutableCopy(this.names), this.path, this.isRoot, this.parentResource != null, Builder.immutableCopy(this.resourceMethods), this.resourceLocator, this.mergeResources(this.childResources), Builder.immutableCopy(this.handlerClasses), Builder.immutableCopy(this.handlerInstances));
            if (this.parentResource != null) {
                this.parentResource.onBuildChildResource(this, resource);
            }
            return resource;
        }

        private static <T> List<T> immutableCopy(List<T> list) {
            return list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(Lists.newArrayList(list));
        }

        private static <T> Set<T> immutableCopy(Set<T> set) {
            if (set.isEmpty()) {
                return Collections.emptySet();
            }
            Set result = Sets.newIdentityHashSet();
            result.addAll(set);
            return set;
        }

        private void processMethodBuilders() {
            while (!this.methodBuilders.isEmpty()) {
                this.methodBuilders.iterator().next().build();
            }
        }

        private void processChildResourceBuilders() {
            while (!this.childResourceBuilders.isEmpty()) {
                this.childResourceBuilders.iterator().next().build();
            }
        }
    }
}

