/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.ws.rs.ext.ParamConverter;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;

abstract class AbstractParamValueExtractor<T> {
    private final ParamConverter<T> paramConverter;
    private final String parameterName;
    private final String defaultValueString;
    private final Value<T> convertedDefaultValue;

    protected AbstractParamValueExtractor(ParamConverter<T> converter, String parameterName, final String defaultValueString) {
        this.paramConverter = converter;
        this.parameterName = parameterName;
        this.defaultValueString = defaultValueString;
        if (defaultValueString != null) {
            this.convertedDefaultValue = Values.lazy((Value)new Value<T>(){

                public T get() {
                    return AbstractParamValueExtractor.this.paramConverter.fromString(defaultValueString);
                }
            });
            if (!converter.getClass().isAnnotationPresent(ParamConverter.Lazy.class)) {
                this.convertedDefaultValue.get();
            }
        } else {
            this.convertedDefaultValue = null;
        }
    }

    public String getName() {
        return this.parameterName;
    }

    public String getDefaultValueString() {
        return this.defaultValueString;
    }

    protected final T fromString(String value) {
        Object result = this.paramConverter.fromString(value);
        if (result == null) {
            return this.defaultValue();
        }
        return (T)result;
    }

    protected final boolean isDefaultValueRegistered() {
        return this.defaultValueString != null;
    }

    protected final T defaultValue() {
        if (!this.isDefaultValueRegistered()) {
            return null;
        }
        return (T)this.convertedDefaultValue.get();
    }
}

