/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.wadl.processor;

import com.google.common.collect.Lists;
import com.sun.research.ws.wadl.Application;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.server.model.internal.ModelProcessorUtil;
import org.glassfish.jersey.server.wadl.WadlApplicationContext;
import org.glassfish.jersey.server.wadl.internal.WadlResource;

@BindingPriority(value=10000)
public class WadlModelProcessor
implements ModelProcessor {
    private final List<ModelProcessorUtil.Method> methodList = Lists.newArrayList();

    public WadlModelProcessor() {
        this.methodList.add(new ModelProcessorUtil.Method("OPTIONS", MediaType.WILDCARD_TYPE, MediaTypes.WADL, OptionsHandler.class));
    }

    @Override
    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        boolean disabled = PropertiesHelper.isProperty((Object)configuration.getProperty("jersey.config.server.wadl.disableWadl"));
        if (disabled) {
            return resourceModel;
        }
        Resource wadlResource = Resource.builder(WadlResource.class).build();
        ResourceModel.Builder builder = ModelProcessorUtil.enhanceResourceModel(resourceModel, false, this.methodList);
        builder.addResource(wadlResource);
        return builder.build();
    }

    @Override
    public ResourceModel processSubResource(ResourceModel resourceModel, Configuration configuration) {
        boolean disabled = PropertiesHelper.isProperty((Object)configuration.getProperty("jersey.config.server.wadl.disableWadl"));
        if (disabled) {
            return resourceModel;
        }
        return ModelProcessorUtil.enhanceResourceModel(resourceModel, true, this.methodList).build();
    }

    public static class OptionsHandler
    implements Inflector<ContainerRequestContext, Response> {
        private final String lastModified = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date());
        @Inject
        private ExtendedUriInfo extendedUriInfo;
        @Context
        private WadlApplicationContext wadlApplicationContext;

        public Response apply(ContainerRequestContext containerRequestContext) {
            RuntimeResource resource = this.extendedUriInfo.getMatchedRuntimeResources().get(0);
            Application wadlApplication = this.wadlApplicationContext.getApplication(containerRequestContext.getUriInfo(), resource.getResources().get(0));
            Response response = Response.ok().type(MediaTypes.WADL).allow(ModelProcessorUtil.getAllowedMethods(resource)).header("Last-modified", (Object)this.lastModified).entity((Object)wadlApplication).build();
            return response;
        }
    }
}

