/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Configuration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.ComponentModelValidator;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.internal.ModelErrors;
import org.glassfish.jersey.server.spi.internal.ParameterValueHelper;

class SubResourceLocatorRouter
implements Router {
    private final ServiceLocator locator;
    private final ResourceMethod locatorModel;
    private final List<Factory<?>> valueProviders;
    private final RuntimeModelBuilder runtimeModelBuilder;
    private final JerseyResourceContext resourceContext;

    public SubResourceLocatorRouter(ServiceLocator locator, RuntimeModelBuilder runtimeModelBuilder, ResourceMethod locatorModel) {
        this.locator = locator;
        this.runtimeModelBuilder = runtimeModelBuilder;
        this.locatorModel = locatorModel;
        this.valueProviders = ParameterValueHelper.createValueProviders(locator, locatorModel.getInvocable());
        this.resourceContext = (JerseyResourceContext)locator.getService(JerseyResourceContext.class, new Annotation[0]);
    }

    @Override
    public Router.Continuation apply(ContainerRequest request) {
        Resource subResource;
        RoutingContext routingCtx = (RoutingContext)Injections.getOrCreate((ServiceLocator)this.locator, RoutingContext.class);
        Object subResourceInstance = this.getResource(routingCtx);
        if (subResourceInstance == null) {
            throw new NotFoundException();
        }
        if (subResourceInstance.getClass().isAssignableFrom(Resource.class)) {
            subResource = (Resource)subResourceInstance;
        } else {
            if (subResourceInstance.getClass().isAssignableFrom(Class.class)) {
                Class clazz = (Class)subResourceInstance;
                subResourceInstance = Injections.getOrCreate((ServiceLocator)this.locator, (Class)clazz);
            } else {
                routingCtx.pushMatchedResource(subResourceInstance);
                this.resourceContext.bindResourceIfSingleton(subResourceInstance);
            }
            Resource.Builder builder = Resource.builder(subResourceInstance.getClass());
            if (builder == null) {
                builder = Resource.builder().name(subResourceInstance.getClass().getName());
            }
            subResource = builder.build();
        }
        ResourceModel resourceModel = new ResourceModel.Builder(true).addResource(subResource).build();
        resourceModel = this.processSubResource(resourceModel);
        this.validate(resourceModel);
        subResource = resourceModel.getResources().get(0);
        for (Class<?> handlerClass : subResource.getHandlerClasses()) {
            this.resourceContext.bindResource(handlerClass);
        }
        Router subResourceAcceptor = this.runtimeModelBuilder.buildModel(resourceModel.getRuntimeResourceModel(), true);
        return Router.Continuation.of(request, subResourceAcceptor);
    }

    private ResourceModel processSubResource(ResourceModel subResourceModel) {
        Configuration configuration = (Configuration)this.locator.getService(Configuration.class, new Annotation[0]);
        Iterable allRankedProviders = Providers.getAllRankedProviders((ServiceLocator)this.locator, ModelProcessor.class);
        Iterable modelProcessors = Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{allRankedProviders});
        for (ModelProcessor modelProcessor : modelProcessors) {
            subResourceModel = modelProcessor.processSubResource(subResourceModel, configuration);
            this.validateEnhancedModel(subResourceModel, modelProcessor);
        }
        return subResourceModel;
    }

    private void validateEnhancedModel(ResourceModel subResourceModel, ModelProcessor modelProcessor) {
        if (subResourceModel.getResources().size() != 1) {
            throw new ProcessingException(LocalizationMessages.ERROR_SUB_RESOURCE_LOCATOR_MORE_RESOURCES(subResourceModel.getResources().size()));
        }
    }

    private void validate(final ResourceModel resourceModel) {
        Errors.process((Runnable)new Runnable(){

            @Override
            public void run() {
                ComponentModelValidator validator = new ComponentModelValidator(SubResourceLocatorRouter.this.locator);
                validator.validate(resourceModel);
                if (Errors.fatalIssuesFound()) {
                    throw new ModelValidationException(LocalizationMessages.ERROR_VALIDATION_SUBRESOURCE(), ModelErrors.getErrorsAsResourceModelIssues());
                }
            }
        });
    }

    private Object getResource(RoutingContext routingCtx) {
        Object resource = routingCtx.peekMatchedResource();
        try {
            Method handlingMethod = this.locatorModel.getInvocable().getHandlingMethod();
            return handlingMethod.invoke(resource, ParameterValueHelper.getParameterValues(this.valueProviders));
        }
        catch (IllegalAccessException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProcessingException) {
                throw (ProcessingException)cause;
            }
            throw new MappableException(cause);
        }
        catch (UndeclaredThrowableException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappableException(ex);
        }
        catch (Throwable t) {
            throw new ProcessingException(t);
        }
    }
}

