/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spi.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.WebApplicationException;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

public final class ParameterValueHelper {
    public static Object[] getParameterValues(List<Factory<?>> valueProviders) {
        Object[] params = new Object[valueProviders.size()];
        try {
            int index = 0;
            for (Factory<?> valueProvider : valueProviders) {
                params[index++] = valueProvider.provide();
            }
            return params;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (MessageBodyProviderNotFoundException e) {
            throw new NotSupportedException((Throwable)e);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new MappableException("Exception obtaining parameters", e);
        }
    }

    public static List<Factory<?>> createValueProviders(ServiceLocator locator, Parameterized parameterized) {
        if (null == parameterized.getParameters() || 0 == parameterized.getParameters().size()) {
            return Collections.emptyList();
        }
        ArrayList<ValueFactoryProvider> valueFactoryProviders = new ArrayList<ValueFactoryProvider>(Providers.getProviders((ServiceLocator)locator, ValueFactoryProvider.class));
        Collections.sort(valueFactoryProviders, new Comparator<ValueFactoryProvider>(){

            @Override
            public int compare(ValueFactoryProvider o1, ValueFactoryProvider o2) {
                return o2.getPriority().getWeight() - o1.getPriority().getWeight();
            }
        });
        boolean entityParamFound = false;
        ArrayList providers = new ArrayList(parameterized.getParameters().size());
        for (Parameter parameter : parameterized.getParameters()) {
            entityParamFound = entityParamFound || Parameter.Source.ENTITY == parameter.getSource();
            providers.add(ParameterValueHelper.getValueFactory(valueFactoryProviders, parameter));
        }
        if (!entityParamFound && Collections.frequency(providers, null) == 1) {
            Parameter parameter;
            int entityParamIndex = providers.lastIndexOf(null);
            parameter = parameterized.getParameters().get(entityParamIndex);
            if (Parameter.Source.UNKNOWN == parameter.getSource() && !parameter.isQualified()) {
                providers.set(entityParamIndex, ParameterValueHelper.getValueFactory(valueFactoryProviders, Parameter.overrideSource(parameter, Parameter.Source.ENTITY)));
            }
        }
        return providers;
    }

    private static Factory<?> getValueFactory(Collection<ValueFactoryProvider> valueFactoryProviders, Parameter parameter) {
        Factory<?> valueFactory = null;
        Iterator<ValueFactoryProvider> vfpIterator = valueFactoryProviders.iterator();
        while (valueFactory == null && vfpIterator.hasNext()) {
            valueFactory = vfpIterator.next().getValueFactory(parameter);
        }
        return valueFactory;
    }

    private ParameterValueHelper() {
    }
}

