/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractFuture;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.ws.rs.NameBinding;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.NullOutputStream;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerMessageBodyWorkersInitializer;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.ResourceBag;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBinder;
import org.glassfish.jersey.server.ServerConfig;
import org.glassfish.jersey.server.ServerRuntime;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.ProcessingProviders;
import org.glassfish.jersey.server.internal.routing.RoutedInflectorExtractorStage;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingStage;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.ComponentModelValidator;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.internal.ModelErrors;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public final class ApplicationHandler {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };
    private final Application application;
    private final ResourceConfig runtimeConfig;
    private final ServiceLocator locator = Injections.createLocator((Binder[])new Binder[]{new ServerBinder(), new ApplicationBinder()});
    private ServerRuntime runtime;

    public ApplicationHandler() {
        this(new Application());
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        this.locator.setDefaultClassAnalyzerName("JerseyClassAnalyzer");
        this.application = this.createApplication(jaxrsApplicationClass);
        this.runtimeConfig = ResourceConfig.createRuntimeConfig(this.application);
        Errors.processWithException((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationHandler.this.initialize();
            }
        });
    }

    public ApplicationHandler(Application application) {
        ResourceConfig rc;
        this.locator.setDefaultClassAnalyzerName("JerseyClassAnalyzer");
        this.application = application;
        if (application instanceof ResourceConfig && (rc = (ResourceConfig)application).getApplicationClass() != null) {
            rc.setApplication(this.createApplication(rc.getApplicationClass()));
        }
        this.runtimeConfig = ResourceConfig.createRuntimeConfig(application);
        Errors.processWithException((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationHandler.this.initialize();
            }
        });
    }

    private Application createApplication(Class<? extends Application> applicationClass) {
        ResourceConfig _rc;
        Class<? extends Application> innerAppClass;
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        Application app = (Application)this.locator.createAndInitialize(applicationClass);
        if (app instanceof ResourceConfig && (innerAppClass = (_rc = (ResourceConfig)app).getApplicationClass()) != null) {
            Application innerApp = this.createApplication(innerAppClass);
            _rc.setApplication(innerApp);
        }
        return app;
    }

    private void initialize() {
        Resource resource;
        LOGGER.info(LocalizationMessages.INIT_MSG(Version.getBuildId()));
        if (this.application instanceof ResourceConfig) {
            ((ResourceConfig)this.application).lock();
        }
        if (!((Boolean)PropertiesHelper.getValue(this.runtimeConfig.getProperties(), (RuntimeType)RuntimeType.SERVER, (String)"jersey.config.disableAutoDiscovery", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            this.runtimeConfig.configureAutoDiscoverableProviders(this.locator);
        }
        this.runtimeConfig.configureMetaProviders(this.locator);
        ResourceBag.Builder resourceBagBuilder = new ResourceBag.Builder();
        for (Class<?> c : this.runtimeConfig.getClasses()) {
            try {
                resource = Resource.from(c);
                if (resource == null) continue;
                resourceBagBuilder.registerResource(c, resource);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (Object o : this.runtimeConfig.getSingletons()) {
            try {
                resource = Resource.from(o.getClass());
                if (resource == null) continue;
                resourceBagBuilder.registerResource(o, resource);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (Resource programmaticResource : this.runtimeConfig.getResources()) {
            resourceBagBuilder.registerProgrammaticResource(programmaticResource);
        }
        ResourceBag resourceBag = resourceBagBuilder.build();
        this.runtimeConfig.lock();
        HashSet<ComponentProvider> componentProviders = new HashSet<ComponentProvider>();
        for (ComponentProvider provider : ServiceFinder.find(ComponentProvider.class)) {
            provider.initialize(this.locator);
            componentProviders.add(provider);
        }
        ComponentBag componentBag = this.runtimeConfig.getComponentBag();
        this.bindProvidersAndResources(componentProviders, componentBag, resourceBag.classes, resourceBag.instances);
        for (ComponentProvider componentProvider : componentProviders) {
            componentProvider.done();
        }
        ProcessingProviders processingProviders = this.getProcessingProviders(componentBag);
        ResourceModel resourceModel = new ResourceModel.Builder(resourceBag.getRootResources(), false).build();
        resourceModel = this.processResourceModel(resourceModel);
        this.validate(resourceModel);
        this.bindEnhancingResourceClasses(resourceModel, resourceBag, componentProviders);
        RuntimeModelBuilder runtimeModelBuilder = (RuntimeModelBuilder)this.locator.getService(RuntimeModelBuilder.class, new Annotation[0]);
        runtimeModelBuilder.setProcessingProviders(processingProviders);
        Router resourceRoutingRoot = runtimeModelBuilder.buildModel(resourceModel.getRuntimeResourceModel(), false);
        ContainerFilteringStage preMatchRequestFilteringStage = ((ContainerFilteringStage.Builder)this.locator.createAndInitialize(ContainerFilteringStage.Builder.class)).build(processingProviders.getPreMatchFilters(), processingProviders.getGlobalResponseFilters());
        RoutingStage routingStage = ((RoutingStage.Builder)this.locator.createAndInitialize(RoutingStage.Builder.class)).build(resourceRoutingRoot);
        ContainerFilteringStage resourceFilteringStage = ((ContainerFilteringStage.Builder)this.locator.createAndInitialize(ContainerFilteringStage.Builder.class)).build(processingProviders.getGlobalRequestFilters(), null);
        RoutedInflectorExtractorStage routedInflectorExtractorStage = (RoutedInflectorExtractorStage)this.locator.createAndInitialize(RoutedInflectorExtractorStage.class);
        Stage rootStage = Stages.chain((Function)((Function)this.locator.createAndInitialize(ReferencesInitializer.class))).to((Function)this.locator.createAndInitialize(ContainerMessageBodyWorkersInitializer.class)).to((ChainableStage)preMatchRequestFilteringStage).to((ChainableStage)routingStage).to((ChainableStage)resourceFilteringStage).build((Stage)routedInflectorExtractorStage);
        for (Object e : componentBag.getInstances(ComponentBag.EXCLUDE_META_PROVIDERS)) {
            this.locator.inject(e);
        }
        for (Object object : resourceBag.instances) {
            this.locator.inject(object);
        }
        JerseyResourceContext jerseyResourceContext = (JerseyResourceContext)this.locator.getService(JerseyResourceContext.class, new Annotation[0]);
        jerseyResourceContext.setResourceModel(resourceModel);
        this.runtime = ((ServerRuntime.Builder)this.locator.createAndInitialize(ServerRuntime.Builder.class)).build((Stage<ContainerRequest>)rootStage);
        this.locator.inject((Object)this);
    }

    private ProcessingProviders getProcessingProviders(ComponentBag componentBag) {
        Collection applicationNameBindings = ReflectionHelper.getAnnotationTypes(this.runtimeConfig.getWrappedApplication().getClass(), NameBinding.class);
        Iterable responseFilters = Providers.getAllRankedProviders((ServiceLocator)this.locator, ContainerResponseFilter.class);
        MultivaluedHashMap nameBoundResponseFiltersInverse = new MultivaluedHashMap();
        MultivaluedHashMap nameBoundRequestFiltersInverse = new MultivaluedHashMap();
        MultivaluedHashMap nameBoundReaderInterceptorsInverse = new MultivaluedHashMap();
        MultivaluedHashMap nameBoundWriterInterceptorsInverse = new MultivaluedHashMap();
        MultivaluedMap nameBoundResponseFilters = ApplicationHandler.filterNameBound(responseFilters, null, componentBag, applicationNameBindings, nameBoundResponseFiltersInverse);
        Iterable requestFilters = Providers.getAllRankedProviders((ServiceLocator)this.locator, ContainerRequestFilter.class);
        ArrayList preMatchFilters = Lists.newArrayList();
        MultivaluedMap nameBoundRequestFilters = ApplicationHandler.filterNameBound(requestFilters, preMatchFilters, componentBag, applicationNameBindings, nameBoundRequestFiltersInverse);
        Iterable readerInterceptors = Providers.getAllRankedProviders((ServiceLocator)this.locator, ReaderInterceptor.class);
        MultivaluedMap nameBoundReaderInterceptors = ApplicationHandler.filterNameBound(readerInterceptors, null, componentBag, applicationNameBindings, nameBoundReaderInterceptorsInverse);
        Iterable writerInterceptors = Providers.getAllRankedProviders((ServiceLocator)this.locator, WriterInterceptor.class);
        MultivaluedMap nameBoundWriterInterceptors = ApplicationHandler.filterNameBound(writerInterceptors, null, componentBag, applicationNameBindings, nameBoundWriterInterceptorsInverse);
        Iterable dynamicFeatures = Providers.getAllProviders((ServiceLocator)this.locator, DynamicFeature.class);
        return new ProcessingProviders(nameBoundRequestFilters, (MultivaluedMap<RankedProvider<ContainerRequestFilter>, Class<? extends Annotation>>)nameBoundRequestFiltersInverse, nameBoundResponseFilters, (MultivaluedMap<RankedProvider<ContainerResponseFilter>, Class<? extends Annotation>>)nameBoundResponseFiltersInverse, nameBoundReaderInterceptors, (MultivaluedMap<RankedProvider<ReaderInterceptor>, Class<? extends Annotation>>)nameBoundReaderInterceptorsInverse, nameBoundWriterInterceptors, (MultivaluedMap<RankedProvider<WriterInterceptor>, Class<? extends Annotation>>)nameBoundWriterInterceptorsInverse, requestFilters, preMatchFilters, responseFilters, readerInterceptors, writerInterceptors, dynamicFeatures);
    }

    private ResourceModel processResourceModel(ResourceModel resourceModel) {
        Iterable allRankedProviders = Providers.getAllRankedProviders((ServiceLocator)this.locator, ModelProcessor.class);
        Iterable modelProcessors = Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable[])new Iterable[]{allRankedProviders});
        for (ModelProcessor modelProcessor : modelProcessors) {
            resourceModel = modelProcessor.processResourceModel(resourceModel, (Configuration)this.getConfiguration());
        }
        return resourceModel;
    }

    private void bindEnhancingResourceClasses(ResourceModel resourceModel, ResourceBag resourceBag, Set<ComponentProvider> componentProviders) {
        HashSet newClasses = Sets.newHashSet();
        HashSet newInstances = Sets.newHashSet();
        for (Resource res : resourceModel.getRootResources()) {
            newClasses.addAll(res.getHandlerClasses());
            newInstances.addAll(res.getHandlerInstances());
        }
        newClasses.removeAll(resourceBag.classes);
        newInstances.removeAll(resourceBag.instances);
        ComponentBag emptyComponentBag = ComponentBag.newInstance((Predicate)new Predicate<ContractProvider>(){

            public boolean apply(ContractProvider input) {
                return false;
            }
        });
        this.bindProvidersAndResources(componentProviders, emptyComponentBag, newClasses, newInstances);
    }

    private static <T> MultivaluedMap<Class<? extends Annotation>, RankedProvider<T>> filterNameBound(Iterable<RankedProvider<T>> all, Collection<RankedProvider<ContainerRequestFilter>> preMatching, ComponentBag componentBag, Collection<Class<? extends Annotation>> applicationNameBindings, MultivaluedMap<RankedProvider<T>, Class<? extends Annotation>> inverseNameBoundMap) {
        MultivaluedHashMap result = new MultivaluedHashMap();
        Iterator<RankedProvider<T>> it = all.iterator();
        while (it.hasNext()) {
            boolean nameBound;
            RankedProvider<T> provider = it.next();
            Class<?> providerClass = provider.getProvider().getClass();
            ContractProvider model = componentBag.getModel(providerClass);
            if (model == null) {
                model = ComponentBag.modelFor(providerClass);
            }
            if (preMatching != null && providerClass.getAnnotation(PreMatching.class) != null) {
                it.remove();
                preMatching.add((RankedProvider<ContainerRequestFilter>)new RankedProvider((Object)((ContainerRequestFilter)provider.getProvider()), model.getPriority(ContainerRequestFilter.class)));
            }
            if ((nameBound = model.isNameBound()) && !applicationNameBindings.isEmpty() && applicationNameBindings.containsAll(model.getNameBindings())) {
                nameBound = false;
            }
            if (!nameBound) continue;
            it.remove();
            for (Class binding : model.getNameBindings()) {
                result.add((Object)binding, provider);
                inverseNameBoundMap.add(provider, (Object)binding);
            }
        }
        return result;
    }

    private void bindProvidersAndResources(Set<ComponentProvider> componentProviders, final ComponentBag componentBag, final Set<Class<?>> resourceClasses, final Set<Object> resourceInstances) {
        JerseyResourceContext resourceContext = (JerseyResourceContext)this.locator.getService(JerseyResourceContext.class, new Annotation[0]);
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        final Set<Class<?>> registeredClasses = this.runtimeConfig.getRegisteredClasses();
        Set classes = Sets.newIdentityHashSet();
        classes.addAll(Sets.filter((Set)componentBag.getClasses(ComponentBag.EXCLUDE_META_PROVIDERS), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> componentClass) {
                return Providers.checkProviderRuntime(componentClass, (ContractProvider)componentBag.getModel(componentClass), (RuntimeType)RuntimeType.SERVER, (!registeredClasses.contains(componentClass) ? 1 : 0) != 0, (boolean)resourceClasses.contains(componentClass));
            }
        }));
        classes.addAll(resourceClasses);
        for (Class componentClass : classes) {
            ContractProvider model = componentBag.getModel(componentClass);
            if (resourceClasses.contains(componentClass)) {
                if (this.bindWithComponentProvider(componentClass, model, componentProviders)) continue;
                if (!Resource.isAcceptable(componentClass)) {
                    LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_COMPONENT(componentClass));
                    continue;
                }
                if (model != null && !Providers.checkProviderRuntime((Class)componentClass, (ContractProvider)model, (RuntimeType)RuntimeType.SERVER, (!registeredClasses.contains(componentClass) ? 1 : 0) != 0, (boolean)true)) {
                    model = null;
                }
                resourceContext.unsafeBindResource(componentClass, model, dc);
                continue;
            }
            ProviderBinder.bindProvider((Class)componentClass, (ContractProvider)model, (DynamicConfiguration)dc);
        }
        HashSet instances = Sets.newHashSet();
        instances.addAll(Sets.filter((Set)componentBag.getInstances(ComponentBag.EXCLUDE_META_PROVIDERS), (Predicate)new Predicate<Object>(){

            public boolean apply(Object component) {
                Class<?> componentClass = component.getClass();
                return Providers.checkProviderRuntime(componentClass, (ContractProvider)componentBag.getModel(componentClass), (RuntimeType)RuntimeType.SERVER, (!registeredClasses.contains(componentClass) ? 1 : 0) != 0, (boolean)resourceInstances.contains(component));
            }
        }));
        instances.addAll(resourceInstances);
        for (Object component : instances) {
            ContractProvider model = componentBag.getModel(component.getClass());
            if (resourceInstances.contains(component)) {
                if (model != null && !Providers.checkProviderRuntime(component.getClass(), (ContractProvider)model, (RuntimeType)RuntimeType.SERVER, (!registeredClasses.contains(component.getClass()) ? 1 : 0) != 0, (boolean)true)) {
                    model = null;
                }
                resourceContext.unsafeBindResource(component, model, dc);
                continue;
            }
            ProviderBinder.bindProvider(component, (ContractProvider)model, (DynamicConfiguration)dc);
        }
        dc.commit();
    }

    private boolean bindWithComponentProvider(Class<?> component, ContractProvider providerModel, Collection<ComponentProvider> componentProviders) {
        Set contracts = providerModel == null ? Collections.emptySet() : providerModel.getContracts();
        for (ComponentProvider provider : componentProviders) {
            if (!provider.bind(component, contracts)) continue;
            return true;
        }
        return false;
    }

    public void registerAdditionalBinders(Iterable<Binder> binders) {
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        for (Binder binder : binders) {
            binder.bind(dc);
        }
        dc.commit();
    }

    private void validate(ResourceModel resourceModel) {
        ComponentModelValidator validator = new ComponentModelValidator(this.locator);
        validator.validate(resourceModel);
        if (Errors.fatalIssuesFound()) {
            throw new ModelValidationException(ModelErrors.getErrorsAsResourceModelIssues());
        }
    }

    public Future<ContainerResponse> apply(ContainerRequest requestContext) {
        return this.apply(requestContext, (OutputStream)new NullOutputStream());
    }

    public Future<ContainerResponse> apply(ContainerRequest request, OutputStream outputStream) {
        FutureResponseWriter responseFuture = new FutureResponseWriter(request.getMethod(), outputStream);
        request.setSecurityContext(DEFAULT_SECURITY_CONTEXT);
        request.setWriter(responseFuture);
        this.handle(request);
        return responseFuture;
    }

    public void handle(ContainerRequest requestContext) {
        this.runtime.process(requestContext);
    }

    public ServiceLocator getServiceLocator() {
        return this.locator;
    }

    public ResourceConfig getConfiguration() {
        return this.runtimeConfig;
    }

    private static class FutureResponseWriter
    extends AbstractFuture<ContainerResponse>
    implements ContainerResponseWriter {
        private static final Logger LOGGER = Logger.getLogger(FutureResponseWriter.class.getName());
        private static final Timer TIMER = new Timer("Jersey application request timer");
        private ContainerResponse response = null;
        private TimerTask timeoutTask = null;
        private ContainerResponseWriter.TimeoutHandler timeoutHandler = null;
        private boolean suspended = false;
        private final Object runtimeLock = new Object();
        private final String requestMethodName;
        private final OutputStream outputStream;

        private FutureResponseWriter(String requestMethodName, OutputStream outputStream) {
            this.requestMethodName = requestMethodName;
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse response) throws ContainerException {
            this.response = response;
            if (contentLength >= 0L) {
                response.getHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
            }
            return this.outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean suspend(long time, TimeUnit unit, ContainerResponseWriter.TimeoutHandler handler) throws IllegalStateException {
            Object object = this.runtimeLock;
            synchronized (object) {
                if (this.suspended) {
                    return false;
                }
                this.suspended = true;
                this.timeoutHandler = handler;
                this.setSuspendTimeout(time, unit);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSuspendTimeout(long time, TimeUnit unit) throws IllegalStateException {
            TimerTask task = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = FutureResponseWriter.this.runtimeLock;
                        synchronized (object) {
                            FutureResponseWriter.this.timeoutHandler.onTimeout(FutureResponseWriter.this);
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.WARNING, LocalizationMessages.SUSPEND_HANDLER_EXECUTION_FAILED(), throwable);
                    }
                }
            };
            Object object = this.runtimeLock;
            synchronized (object) {
                if (!this.suspended) {
                    throw new IllegalStateException(LocalizationMessages.SUSPEND_NOT_SUSPENDED());
                }
                if (this.timeoutTask != null) {
                    this.timeoutTask.cancel();
                    this.timeoutTask = null;
                }
                if (time <= 0L) {
                    return;
                }
                this.timeoutTask = task;
                try {
                    TIMER.schedule(task, unit.toMillis(time));
                }
                catch (IllegalStateException ex) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.SUSPEND_SHEDULING_ERROR(), ex);
                }
            }
        }

        @Override
        public void commit() {
            ContainerResponse current = this.response;
            if (current != null) {
                if ("HEAD".equals(this.requestMethodName) && current.hasEntity()) {
                    current.setEntity(null);
                }
                super.set((Object)current);
            }
        }

        @Override
        public void failure(Throwable error) {
            super.setException(error);
        }

        @Override
        public boolean enableResponseBuffering() {
            return true;
        }

        protected void interruptTask() {
        }
    }

    private class ApplicationBinder
    extends AbstractBinder {
        private ApplicationBinder() {
        }

        protected void configure() {
            this.bindFactory(new RuntimeConfigProvider()).to(ServerConfig.class).to(Configuration.class).in(Singleton.class);
            this.bindFactory(new JaxrsApplicationProvider()).to(Application.class).in(Singleton.class);
            this.bind(ApplicationHandler.this).to(ApplicationHandler.class);
        }

        private class RuntimeConfigProvider
        implements Factory<ServerConfig> {
            private RuntimeConfigProvider() {
            }

            public ServerConfig provide() {
                return ApplicationHandler.this.runtimeConfig;
            }

            public void dispose(ServerConfig instance) {
            }
        }

        private class JaxrsApplicationProvider
        implements Factory<Application> {
            private JaxrsApplicationProvider() {
            }

            public Application provide() {
                return ApplicationHandler.this.application;
            }

            public void dispose(Application instance) {
            }
        }
    }
}

