/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public class JerseyRequestTimeoutHandler {
    private static final Logger LOGGER = Logger.getLogger(JerseyRequestTimeoutHandler.class.getName());
    private static final Timer TIMER = new Timer("jersey-request-timeout-handler-scheduler");
    private TimerTask timeoutTask = null;
    private ContainerResponseWriter.TimeoutHandler timeoutHandler = null;
    private boolean suspended = false;
    private final Object runtimeLock = new Object();
    private final ContainerResponseWriter containerResponseWriter;

    public JerseyRequestTimeoutHandler(ContainerResponseWriter containerResponseWriter) {
        this.containerResponseWriter = containerResponseWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspend(long timeOut, TimeUnit unit, ContainerResponseWriter.TimeoutHandler handler) {
        Object object = this.runtimeLock;
        synchronized (object) {
            if (this.suspended) {
                return false;
            }
            this.suspended = true;
            this.timeoutHandler = handler;
            this.containerResponseWriter.setSuspendTimeout(timeOut, unit);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspendTimeout(long timeOut, TimeUnit unit) throws IllegalStateException {
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = JerseyRequestTimeoutHandler.this.runtimeLock;
                    synchronized (object) {
                        JerseyRequestTimeoutHandler.this.timeoutHandler.onTimeout(JerseyRequestTimeoutHandler.this.containerResponseWriter);
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.SUSPEND_HANDLER_EXECUTION_FAILED(), throwable);
                }
            }
        };
        Object object = this.runtimeLock;
        synchronized (object) {
            if (!this.suspended) {
                throw new IllegalStateException(LocalizationMessages.SUSPEND_NOT_SUSPENDED());
            }
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
                this.timeoutTask = null;
            }
            if (timeOut <= 0L) {
                return;
            }
            this.timeoutTask = task;
            try {
                TIMER.schedule(task, unit.toMillis(timeOut));
            }
            catch (IllegalStateException ex) {
                LOGGER.log(Level.WARNING, LocalizationMessages.SUSPEND_SHEDULING_ERROR(), ex);
            }
        }
    }
}

