/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class UniformTimeSnapshot {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final long[] values;
    private final long timeInterval;
    private final TimeUnit timeIntervalUnit;

    public UniformTimeSnapshot(Collection<Long> values, long timeInterval, TimeUnit timeIntervalUnit) {
        this.timeInterval = timeInterval;
        this.timeIntervalUnit = timeIntervalUnit;
        Object[] copy = values.toArray();
        this.values = new long[copy.length];
        for (int i = 0; i < copy.length; ++i) {
            this.values[i] = (Long)copy[i];
        }
        Arrays.sort(this.values);
    }

    public UniformTimeSnapshot(long[] values, long timeInterval, TimeUnit timeIntervalUnit) {
        this.timeInterval = timeInterval;
        this.timeIntervalUnit = timeIntervalUnit;
        this.values = Arrays.copyOf(values, values.length);
        Arrays.sort(this.values);
    }

    public double getValue(double quantile) {
        if (quantile < 0.0 || quantile > 1.0 || Double.isNaN(quantile)) {
            throw new IllegalArgumentException(quantile + " is not in [0..1] range");
        }
        if (this.values.length == 0) {
            return 0.0;
        }
        double pos = quantile * (double)(this.values.length + 1);
        int index = (int)pos;
        if (index < 1) {
            return this.values[0];
        }
        if (index >= this.values.length) {
            return this.values[this.values.length - 1];
        }
        double lower = this.values[index - 1];
        double upper = this.values[index];
        return lower + (pos - Math.floor(pos)) * (upper - lower);
    }

    public long size() {
        return this.values.length;
    }

    public long[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public long getMax() {
        if (this.values.length == 0) {
            return 0L;
        }
        return this.values[this.values.length - 1];
    }

    public long getMin() {
        if (this.values.length == 0) {
            return 0L;
        }
        return this.values[0];
    }

    public double getMean() {
        if (this.values.length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (long value : this.values) {
            sum += (double)value;
        }
        return sum / (double)this.values.length;
    }

    public double getStdDev() {
        if (this.values.length <= 1) {
            return 0.0;
        }
        double mean = this.getMean();
        double sum = 0.0;
        for (long value : this.values) {
            double diff = (double)value - mean;
            sum += diff * diff;
        }
        double variance = sum / (double)(this.values.length - 1);
        return Math.sqrt(variance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(OutputStream output) {
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(output, UTF_8));){
            for (long value : this.values) {
                out.printf("%d%n", value);
            }
        }
    }

    public long getTimeInterval(TimeUnit timeUnit) {
        return timeUnit.convert(this.timeInterval, this.timeIntervalUnit);
    }
}

