/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.NameBinding;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Collections2;
import jersey.repackaged.com.google.common.collect.Lists;
import jersey.repackaged.com.google.common.collect.Sets;
import jersey.repackaged.com.google.common.util.concurrent.AbstractFuture;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.ServiceConfigurationError;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.CompositeBinder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.NullOutputStream;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.ExecutorProviders;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceBag;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBinder;
import org.glassfish.jersey.server.ServerConfig;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.ServerRuntime;
import org.glassfish.jersey.server.internal.JerseyRequestTimeoutHandler;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.ProcessingProviders;
import org.glassfish.jersey.server.internal.monitoring.ApplicationEventImpl;
import org.glassfish.jersey.server.internal.monitoring.CompositeApplicationEventListener;
import org.glassfish.jersey.server.internal.monitoring.MonitoringContainerListener;
import org.glassfish.jersey.server.internal.process.ReferencesInitializer;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.Routing;
import org.glassfish.jersey.server.model.ComponentModelValidator;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.internal.ModelErrors;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.ExternalRequestScope;

public final class ApplicationHandler
implements ContainerLifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };
    private final Application application;
    private final ResourceConfig runtimeConfig;
    private final ServerRuntime runtime;
    private final Iterable<ContainerLifecycleListener> containerLifecycleListeners;
    private final InjectionManager injectionManager;
    private MessageBodyWorkers msgBodyWorkers;

    public ApplicationHandler() {
        this(new Application());
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        this.injectionManager = Injections.createInjectionManager((Binder[])new Binder[0]);
        this.injectionManager.register((Binder)CompositeBinder.wrap((Binder[])new Binder[]{new ServerBinder(null, this.injectionManager), new ApplicationBinder()}));
        LazyValue<Iterable<ComponentProvider>> componentProviders = ApplicationHandler.getLazyInitializedComponentProviders(this.injectionManager);
        this.application = this.createApplication(jaxrsApplicationClass, (Value<Iterable<ComponentProvider>>)componentProviders);
        this.runtimeConfig = ResourceConfig.createRuntimeConfig(this.application);
        this.runtime = (ServerRuntime)Errors.processWithException(() -> this.initialize((Iterable)componentProviders.get()));
        this.containerLifecycleListeners = Providers.getAllProviders((InjectionManager)this.injectionManager, ContainerLifecycleListener.class);
    }

    public ApplicationHandler(Application application) {
        this(application, null, null);
    }

    public ApplicationHandler(Application application, Binder customBinder) {
        this(application, customBinder, null);
    }

    public ApplicationHandler(Application application, Binder customBinder, Object parentManager) {
        ResourceConfig rc;
        this.injectionManager = Injections.createInjectionManager((Object)parentManager, (Binder[])new Binder[0]);
        this.injectionManager.register((Binder)CompositeBinder.wrap((Binder[])new Binder[]{new ServerBinder(application.getProperties(), this.injectionManager), new ApplicationBinder(), customBinder}));
        LazyValue<Iterable<ComponentProvider>> componentProviders = ApplicationHandler.getLazyInitializedComponentProviders(this.injectionManager);
        this.application = application;
        if (application instanceof ResourceConfig && (rc = (ResourceConfig)application).getApplicationClass() != null) {
            rc.setApplication(this.createApplication(rc.getApplicationClass(), (Value<Iterable<ComponentProvider>>)componentProviders));
        }
        this.runtimeConfig = ResourceConfig.createRuntimeConfig(application);
        this.runtime = (ServerRuntime)Errors.processWithException(() -> this.initialize((Iterable)componentProviders.get()));
        this.containerLifecycleListeners = Providers.getAllProviders((InjectionManager)this.injectionManager, ContainerLifecycleListener.class);
    }

    private Application createApplication(final Class<? extends Application> applicationClass, Value<Iterable<ComponentProvider>> componentProvidersValue) {
        ResourceConfig _rc;
        Class<? extends Application> innerAppClass;
        Application app;
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        Iterable componentProviders = (Iterable)componentProvidersValue.get();
        boolean appClassBound = false;
        for (ComponentProvider cp : componentProviders) {
            if (!cp.bind(applicationClass, Collections.emptySet())) continue;
            appClassBound = true;
            break;
        }
        if (!appClassBound && applicationClass.isAnnotationPresent(Singleton.class)) {
            AbstractBinder binder = new AbstractBinder(){

                protected void configure() {
                    this.bindAsContract(applicationClass).in(Singleton.class);
                }
            };
            this.injectionManager.register((Binder)binder);
            appClassBound = true;
        }
        Application application = app = appClassBound ? (Application)this.injectionManager.getInstance(applicationClass) : (Application)this.injectionManager.createAndInitialize(applicationClass);
        if (app instanceof ResourceConfig && (innerAppClass = (_rc = (ResourceConfig)app).getApplicationClass()) != null) {
            Application innerApp = this.createApplication(innerAppClass, componentProvidersValue);
            _rc.setApplication(innerApp);
        }
        return app;
    }

    private static LazyValue<Iterable<ComponentProvider>> getLazyInitializedComponentProviders(InjectionManager injectionManager) {
        return Values.lazy(() -> {
            LinkedList<ComponentProvider> result = new LinkedList<ComponentProvider>();
            for (RankedProvider<ComponentProvider> rankedProvider : ApplicationHandler.getRankedComponentProviders()) {
                ComponentProvider provider = (ComponentProvider)rankedProvider.getProvider();
                provider.initialize(injectionManager);
                result.add(provider);
            }
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerRuntime initialize(Iterable<ComponentProvider> componentProviders) {
        ResourceModel resourceModel;
        ProcessingProviders processingProviders;
        ComponentBag componentBag;
        ResourceBag resourceBag;
        LOGGER.config(LocalizationMessages.INIT_MSG(Version.getBuildId()));
        if (this.application instanceof ResourceConfig) {
            ((ResourceConfig)this.application).lock();
        }
        boolean ignoreValidationErrors = ServerProperties.getValue(this.runtimeConfig.getProperties(), "jersey.config.server.resource.validation.ignoreErrors", Boolean.FALSE, Boolean.class);
        boolean disableValidation = ServerProperties.getValue(this.runtimeConfig.getProperties(), "jersey.config.server.resource.validation.disable", Boolean.FALSE, Boolean.class);
        CompositeApplicationEventListener compositeListener = null;
        Errors.mark();
        try {
            boolean bl;
            Resource resource;
            if (!((Boolean)CommonProperties.getValue(this.runtimeConfig.getProperties(), (RuntimeType)RuntimeType.SERVER, (String)"jersey.config.disableAutoDiscovery", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
                this.runtimeConfig.configureAutoDiscoverableProviders(this.injectionManager);
            } else {
                this.runtimeConfig.configureForcedAutoDiscoverableProviders(this.injectionManager);
            }
            this.runtimeConfig.configureMetaProviders(this.injectionManager);
            ResourceBag.Builder resourceBagBuilder = new ResourceBag.Builder();
            for (Resource resource2 : this.runtimeConfig.getResources()) {
                resourceBagBuilder.registerProgrammaticResource(resource2);
            }
            for (Class clazz : this.runtimeConfig.getClasses()) {
                try {
                    resource = Resource.from(clazz, disableValidation);
                    if (resource == null) continue;
                    resourceBagBuilder.registerResource(clazz, resource);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warning(ex.getMessage());
                }
            }
            for (Object object : this.runtimeConfig.getSingletons()) {
                try {
                    resource = Resource.from(object.getClass(), disableValidation);
                    if (resource == null) continue;
                    resourceBagBuilder.registerResource(object, resource);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warning(ex.getMessage());
                }
            }
            resourceBag = resourceBagBuilder.build();
            this.runtimeConfig.lock();
            componentBag = this.runtimeConfig.getComponentBag();
            Class[] extScopes = ServiceFinder.find(ExternalRequestScope.class, (boolean)true).toClassArray();
            boolean bl2 = false;
            if (extScopes.length == 1) {
                for (ComponentProvider componentProvider : componentProviders) {
                    if (!componentProvider.bind(extScopes[0], new HashSet<Class<?>>(){
                        {
                            this.add(ExternalRequestScope.class);
                        }
                    })) continue;
                    bl = true;
                    break;
                }
            } else if (extScopes.length > 1 && LOGGER.isLoggable(Level.WARNING)) {
                StringBuilder scopeList = new StringBuilder("\n");
                for (Class clazz : extScopes) {
                    scopeList.append("   ").append(clazz.getTypeParameters()[0]).append('\n');
                }
                LOGGER.warning(LocalizationMessages.WARNING_TOO_MANY_EXTERNAL_REQ_SCOPES(scopeList.toString()));
            }
            if (!bl) {
                this.injectionManager.register((Binder)new ServerRuntime.NoopExternalRequestScopeBinder());
            }
            this.bindProvidersAndResources(componentProviders, componentBag, resourceBag.classes, resourceBag.instances);
            for (ComponentProvider componentProvider : componentProviders) {
                componentProvider.done();
            }
            Iterable appEventListeners = Providers.getAllProviders((InjectionManager)this.injectionManager, ApplicationEventListener.class, (RankedComparator)new RankedComparator());
            if (appEventListeners.iterator().hasNext()) {
                compositeListener = new CompositeApplicationEventListener(appEventListeners);
                compositeListener.onEvent(new ApplicationEventImpl(ApplicationEvent.Type.INITIALIZATION_START, this.runtimeConfig, componentBag.getRegistrations(), resourceBag.classes, resourceBag.instances, null));
            }
            processingProviders = this.getProcessingProviders(componentBag);
            GenericType<Ref<ProcessingProviders>> genericType = new GenericType<Ref<ProcessingProviders>>(){};
            Ref refProcessingProvider = (Ref)this.injectionManager.getInstance(genericType.getType());
            refProcessingProvider.set((Object)processingProviders);
            resourceModel = new ResourceModel.Builder(resourceBag.getRootResources(), false).build();
            resourceModel = this.processResourceModel(resourceModel);
            if (!disableValidation) {
                ComponentModelValidator validator = new ComponentModelValidator(this.injectionManager);
                validator.validate(resourceModel);
            }
            if (Errors.fatalIssuesFound() && !ignoreValidationErrors) {
                throw new ModelValidationException(LocalizationMessages.RESOURCE_MODEL_VALIDATION_FAILED_AT_INIT(), ModelErrors.getErrorsAsResourceModelIssues(true));
            }
        }
        finally {
            if (ignoreValidationErrors) {
                Errors.logErrors((boolean)true);
                Errors.reset();
            } else {
                Errors.unmark();
            }
        }
        this.bindEnhancingResourceClasses(resourceModel, resourceBag, componentProviders);
        ExecutorProviders.createInjectionBindings((InjectionManager)this.injectionManager);
        JerseyResourceContext jerseyResourceContext = (JerseyResourceContext)this.injectionManager.getInstance(JerseyResourceContext.class);
        jerseyResourceContext.setResourceModel(resourceModel);
        this.msgBodyWorkers = (MessageBodyWorkers)this.injectionManager.getInstance(MessageBodyWorkers.class);
        ReferencesInitializer referencesInitializer = (ReferencesInitializer)this.injectionManager.createAndInitialize(ReferencesInitializer.class);
        ContainerFilteringStage containerFilteringStage = new ContainerFilteringStage(processingProviders.getPreMatchFilters(), processingProviders.getGlobalResponseFilters());
        ChainableStage<RequestProcessingContext> routingStage = Routing.forModel(resourceModel.getRuntimeResourceModel()).beanManager(this.injectionManager).resourceContext(jerseyResourceContext).configuration((Configuration)this.runtimeConfig).entityProviders(this.msgBodyWorkers).processingProviders(processingProviders).buildStage();
        ContainerFilteringStage containerFilteringStage2 = new ContainerFilteringStage(processingProviders.getGlobalRequestFilters(), null);
        Stage rootStage = Stages.chain((Function)referencesInitializer).to((ChainableStage)containerFilteringStage).to(routingStage).to((ChainableStage)containerFilteringStage2).build(Routing.matchedEndpointExtractor());
        ServerRuntime serverRuntime = ((ServerRuntime.Builder)this.injectionManager.createAndInitialize(ServerRuntime.Builder.class)).build((Stage<RequestProcessingContext>)rootStage, compositeListener, processingProviders);
        for (Object e : componentBag.getInstances(ComponentBag.EXCLUDE_META_PROVIDERS)) {
            this.injectionManager.inject(e);
        }
        for (Object object : resourceBag.instances) {
            this.injectionManager.inject(object);
        }
        ApplicationHandler.logApplicationInitConfiguration(this.injectionManager, resourceBag, processingProviders);
        if (compositeListener != null) {
            ApplicationEventImpl applicationEventImpl = new ApplicationEventImpl(ApplicationEvent.Type.INITIALIZATION_APP_FINISHED, this.runtimeConfig, componentBag.getRegistrations(), resourceBag.classes, resourceBag.instances, resourceModel);
            compositeListener.onEvent(applicationEventImpl);
            MonitoringContainerListener monitoringContainerListener = (MonitoringContainerListener)this.injectionManager.getInstance(MonitoringContainerListener.class);
            monitoringContainerListener.init(compositeListener, applicationEventImpl);
        }
        return serverRuntime;
    }

    private static void logApplicationInitConfiguration(InjectionManager injectionManager, ResourceBag resourceBag, ProcessingProviders processingProviders) {
        Set messageBodyWriters;
        Set messageBodyReaders;
        if (!LOGGER.isLoggable(Level.CONFIG)) {
            return;
        }
        StringBuilder sb = new StringBuilder(LocalizationMessages.LOGGING_APPLICATION_INITIALIZED()).append('\n');
        List<Resource> rootResourceClasses = resourceBag.getRootResources();
        if (!rootResourceClasses.isEmpty()) {
            sb.append(LocalizationMessages.LOGGING_ROOT_RESOURCE_CLASSES()).append(":");
            for (Resource r : rootResourceClasses) {
                for (Class<?> clazz : r.getHandlerClasses()) {
                    sb.append('\n').append("  ").append(clazz.getName());
                }
            }
        }
        sb.append('\n');
        if (LOGGER.isLoggable(Level.FINE)) {
            messageBodyReaders = Sets.newHashSet((Iterable)Providers.getAllProviders((InjectionManager)injectionManager, MessageBodyReader.class));
            messageBodyWriters = Sets.newHashSet((Iterable)Providers.getAllProviders((InjectionManager)injectionManager, MessageBodyWriter.class));
        } else {
            messageBodyReaders = Providers.getCustomProviders((InjectionManager)injectionManager, MessageBodyReader.class);
            messageBodyWriters = Providers.getCustomProviders((InjectionManager)injectionManager, MessageBodyWriter.class);
        }
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_PRE_MATCH_FILTERS(), processingProviders.getPreMatchFilters(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_GLOBAL_REQUEST_FILTERS(), processingProviders.getGlobalRequestFilters(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_GLOBAL_RESPONSE_FILTERS(), processingProviders.getGlobalResponseFilters(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_GLOBAL_READER_INTERCEPTORS(), processingProviders.getGlobalReaderInterceptors(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_GLOBAL_WRITER_INTERCEPTORS(), processingProviders.getGlobalWriterInterceptors(), sb);
        ApplicationHandler.printNameBoundProviders(LocalizationMessages.LOGGING_NAME_BOUND_REQUEST_FILTERS(), processingProviders.getNameBoundRequestFilters(), sb);
        ApplicationHandler.printNameBoundProviders(LocalizationMessages.LOGGING_NAME_BOUND_RESPONSE_FILTERS(), processingProviders.getNameBoundResponseFilters(), sb);
        ApplicationHandler.printNameBoundProviders(LocalizationMessages.LOGGING_NAME_BOUND_READER_INTERCEPTORS(), processingProviders.getNameBoundReaderInterceptors(), sb);
        ApplicationHandler.printNameBoundProviders(LocalizationMessages.LOGGING_NAME_BOUND_WRITER_INTERCEPTORS(), processingProviders.getNameBoundWriterInterceptors(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_DYNAMIC_FEATURES(), processingProviders.getDynamicFeatures(), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_MESSAGE_BODY_READERS(), Collections2.transform((Collection)messageBodyReaders, new WorkersToStringTransform()), sb);
        ApplicationHandler.printProviders(LocalizationMessages.LOGGING_MESSAGE_BODY_WRITERS(), Collections2.transform((Collection)messageBodyWriters, new WorkersToStringTransform()), sb);
        LOGGER.log(Level.CONFIG, sb.toString());
    }

    private static <T> void printNameBoundProviders(String title, Map<Class<? extends Annotation>, List<RankedProvider<T>>> providers, StringBuilder sb) {
        if (!providers.isEmpty()) {
            sb.append(title).append(":").append('\n');
            for (Map.Entry<Class<Annotation>, List<RankedProvider<T>>> entry : providers.entrySet()) {
                for (RankedProvider<T> rankedProvider : entry.getValue()) {
                    sb.append("   ").append(LocalizationMessages.LOGGING_PROVIDER_BOUND(rankedProvider, entry.getKey())).append('\n');
                }
            }
        }
    }

    private static <T> void printProviders(String title, Iterable<T> providers, StringBuilder sb) {
        Iterator<T> iterator = providers.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            if (first) {
                sb.append(title).append(":").append('\n');
                first = false;
            }
            T provider = iterator.next();
            sb.append("   ").append(provider).append('\n');
        }
    }

    private static Iterable<RankedProvider<ComponentProvider>> getRankedComponentProviders() throws ServiceConfigurationError {
        LinkedList<RankedProvider<ComponentProvider>> result = new LinkedList<RankedProvider<ComponentProvider>>();
        for (ComponentProvider provider : ServiceFinder.find(ComponentProvider.class)) {
            result.add((RankedProvider<ComponentProvider>)new RankedProvider((Object)provider));
        }
        Collections.sort(result, new RankedComparator(RankedComparator.Order.DESCENDING));
        return result;
    }

    private ProcessingProviders getProcessingProviders(ComponentBag componentBag) {
        Collection applicationNameBindings = ReflectionHelper.getAnnotationTypes(ResourceConfig.unwrapApplication(this.runtimeConfig).getClass(), NameBinding.class);
        MultivaluedHashMap nameBoundRespFiltersInverse = new MultivaluedHashMap();
        MultivaluedHashMap nameBoundReqFiltersInverse = new MultivaluedHashMap();
        MultivaluedHashMap nameBoundReaderInterceptorsInverse = new MultivaluedHashMap();
        MultivaluedHashMap nameBoundWriterInterceptorsInverse = new MultivaluedHashMap();
        Iterable responseFilters = Providers.getAllRankedProviders((InjectionManager)this.injectionManager, ContainerResponseFilter.class);
        MultivaluedMap nameBoundResponseFilters = ApplicationHandler.filterNameBound(responseFilters, null, componentBag, applicationNameBindings, nameBoundRespFiltersInverse);
        Iterable requestFilters = Providers.getAllRankedProviders((InjectionManager)this.injectionManager, ContainerRequestFilter.class);
        ArrayList preMatchFilters = Lists.newArrayList();
        MultivaluedMap nameBoundReqFilters = ApplicationHandler.filterNameBound(requestFilters, preMatchFilters, componentBag, applicationNameBindings, nameBoundReqFiltersInverse);
        Iterable readerInterceptors = Providers.getAllRankedProviders((InjectionManager)this.injectionManager, ReaderInterceptor.class);
        MultivaluedMap nameBoundReaderInterceptors = ApplicationHandler.filterNameBound(readerInterceptors, null, componentBag, applicationNameBindings, nameBoundReaderInterceptorsInverse);
        Iterable writerInterceptors = Providers.getAllRankedProviders((InjectionManager)this.injectionManager, WriterInterceptor.class);
        MultivaluedMap nameBoundWriterInterceptors = ApplicationHandler.filterNameBound(writerInterceptors, null, componentBag, applicationNameBindings, nameBoundWriterInterceptorsInverse);
        Iterable dynamicFeatures = Providers.getAllProviders((InjectionManager)this.injectionManager, DynamicFeature.class);
        return new ProcessingProviders(nameBoundReqFilters, (MultivaluedMap<RankedProvider<ContainerRequestFilter>, Class<? extends Annotation>>)nameBoundReqFiltersInverse, nameBoundResponseFilters, (MultivaluedMap<RankedProvider<ContainerResponseFilter>, Class<? extends Annotation>>)nameBoundRespFiltersInverse, nameBoundReaderInterceptors, (MultivaluedMap<RankedProvider<ReaderInterceptor>, Class<? extends Annotation>>)nameBoundReaderInterceptorsInverse, nameBoundWriterInterceptors, (MultivaluedMap<RankedProvider<WriterInterceptor>, Class<? extends Annotation>>)nameBoundWriterInterceptorsInverse, requestFilters, preMatchFilters, responseFilters, readerInterceptors, writerInterceptors, dynamicFeatures);
    }

    private ResourceModel processResourceModel(ResourceModel resourceModel) {
        Iterable allRankedProviders = Providers.getAllRankedProviders((InjectionManager)this.injectionManager, ModelProcessor.class);
        Iterable modelProcessors = Providers.sortRankedProviders((RankedComparator)new RankedComparator(), (Iterable)allRankedProviders);
        for (ModelProcessor modelProcessor : modelProcessors) {
            resourceModel = modelProcessor.processResourceModel(resourceModel, (Configuration)this.getConfiguration());
        }
        return resourceModel;
    }

    private void bindEnhancingResourceClasses(ResourceModel resourceModel, ResourceBag resourceBag, Iterable<ComponentProvider> componentProviders) {
        HashSet newClasses = Sets.newHashSet();
        HashSet newInstances = Sets.newHashSet();
        for (Resource res : resourceModel.getRootResources()) {
            newClasses.addAll(res.getHandlerClasses());
            newInstances.addAll(res.getHandlerInstances());
        }
        newClasses.removeAll(resourceBag.classes);
        newInstances.removeAll(resourceBag.instances);
        ComponentBag emptyComponentBag = ComponentBag.newInstance(input -> false);
        this.bindProvidersAndResources(componentProviders, emptyComponentBag, newClasses, newInstances);
    }

    private static <T> MultivaluedMap<Class<? extends Annotation>, RankedProvider<T>> filterNameBound(Iterable<RankedProvider<T>> all, Collection<RankedProvider<ContainerRequestFilter>> preMatchingFilters, ComponentBag componentBag, Collection<Class<? extends Annotation>> applicationNameBindings, MultivaluedMap<RankedProvider<T>, Class<? extends Annotation>> inverseNameBoundMap) {
        MultivaluedHashMap result = new MultivaluedHashMap();
        Iterator<RankedProvider<T>> it = all.iterator();
        while (it.hasNext()) {
            boolean nameBound;
            boolean preMatching;
            ContractProvider model;
            RankedProvider<T> provider = it.next();
            Class providerClass = provider.getProvider().getClass();
            Set contractTypes = provider.getContractTypes();
            if (contractTypes != null && !contractTypes.contains(providerClass)) {
                providerClass = ReflectionHelper.theMostSpecificTypeOf((Set)contractTypes);
            }
            if ((model = componentBag.getModel(providerClass)) == null) {
                model = ComponentBag.modelFor((Class)providerClass);
            }
            boolean bl = preMatching = providerClass.getAnnotation(PreMatching.class) != null;
            if (preMatching && preMatchingFilters != null) {
                it.remove();
                preMatchingFilters.add((RankedProvider<ContainerRequestFilter>)new RankedProvider((Object)((ContainerRequestFilter)provider.getProvider()), model.getPriority(ContainerRequestFilter.class)));
            }
            if ((nameBound = model.isNameBound()) && !applicationNameBindings.isEmpty() && applicationNameBindings.containsAll(model.getNameBindings())) {
                nameBound = false;
            }
            if (!nameBound) continue;
            if (!preMatching) {
                it.remove();
                for (Class binding : model.getNameBindings()) {
                    result.add((Object)binding, provider);
                    inverseNameBoundMap.add(provider, (Object)binding);
                }
                continue;
            }
            LOGGER.warning(LocalizationMessages.PREMATCHING_ALSO_NAME_BOUND(providerClass));
        }
        return result;
    }

    private void bindProvidersAndResources(Iterable<ComponentProvider> componentProviders, ComponentBag componentBag, Collection<Class<?>> resourceClasses, Collection<Object> resourceInstances) {
        JerseyResourceContext resourceContext = (JerseyResourceContext)this.injectionManager.getInstance(JerseyResourceContext.class);
        Set<Class<?>> registeredClasses = this.runtimeConfig.getRegisteredClasses();
        Predicate<Class> correctlyConfigured = componentClass -> Providers.checkProviderRuntime((Class)componentClass, (ContractProvider)componentBag.getModel(componentClass), (RuntimeType)RuntimeType.SERVER, (!registeredClasses.contains(componentClass) ? 1 : 0) != 0, (boolean)resourceClasses.contains(componentClass));
        BiPredicate<Class, ContractProvider> correctlyConfiguredResource = (resourceClass, model) -> Providers.checkProviderRuntime((Class)resourceClass, (ContractProvider)model, (RuntimeType)RuntimeType.SERVER, (!registeredClasses.contains(resourceClass) ? 1 : 0) != 0, (boolean)true);
        Set componentClassses = componentBag.getClasses(ComponentBag.EXCLUDE_META_PROVIDERS).stream().filter(correctlyConfigured).collect(Collectors.toSet());
        Set<Class> classes = Collections.newSetFromMap(new IdentityHashMap());
        classes.addAll(componentClassses);
        classes.addAll(resourceClasses);
        for (Class componentClass2 : classes) {
            ContractProvider model2;
            if (this.bindWithComponentProvider(componentClass2, model2 = componentBag.getModel(componentClass2), componentProviders)) continue;
            if (resourceClasses.contains(componentClass2)) {
                if (!Resource.isAcceptable(componentClass2)) {
                    LOGGER.warning(LocalizationMessages.NON_INSTANTIABLE_COMPONENT(componentClass2));
                    continue;
                }
                if (model2 != null && !correctlyConfiguredResource.test(componentClass2, model2)) {
                    model2 = null;
                }
                resourceContext.unsafeBindResource(componentClass2, model2, this.injectionManager);
                continue;
            }
            ProviderBinder.bindProvider((Class)componentClass2, (ContractProvider)model2, (InjectionManager)this.injectionManager);
        }
        Set instances = componentBag.getInstances(ComponentBag.EXCLUDE_META_PROVIDERS).stream().filter(instance -> correctlyConfigured.test(instance.getClass())).collect(Collectors.toSet());
        instances.addAll(resourceInstances);
        for (Object component : instances) {
            ContractProvider model3 = componentBag.getModel(component.getClass());
            if (resourceInstances.contains(component)) {
                if (model3 != null && !correctlyConfiguredResource.test(component.getClass(), model3)) {
                    model3 = null;
                }
                resourceContext.unsafeBindResource(component, model3, this.injectionManager);
                continue;
            }
            ProviderBinder.bindProvider(component, (ContractProvider)model3, (InjectionManager)this.injectionManager);
        }
    }

    private boolean bindWithComponentProvider(Class<?> component, ContractProvider providerModel, Iterable<ComponentProvider> componentProviders) {
        Set contracts = providerModel == null ? Collections.emptySet() : providerModel.getContracts();
        for (ComponentProvider provider : componentProviders) {
            if (!provider.bind(component, contracts)) continue;
            return true;
        }
        return false;
    }

    public Future<ContainerResponse> apply(ContainerRequest requestContext) {
        return this.apply(requestContext, (OutputStream)new NullOutputStream());
    }

    public Future<ContainerResponse> apply(ContainerRequest request, OutputStream outputStream) {
        FutureResponseWriter responseFuture = new FutureResponseWriter(request.getMethod(), outputStream, this.runtime.getBackgroundScheduler());
        if (request.getSecurityContext() == null) {
            request.setSecurityContext(DEFAULT_SECURITY_CONTEXT);
        }
        request.setWriter(responseFuture);
        this.handle(request);
        return responseFuture;
    }

    public void handle(ContainerRequest request) {
        request.setWorkers(this.msgBodyWorkers);
        this.runtime.process(request);
    }

    public InjectionManager getInjectionManager() {
        return this.injectionManager;
    }

    public ResourceConfig getConfiguration() {
        return this.runtimeConfig;
    }

    @Override
    public void onStartup(Container container) {
        for (ContainerLifecycleListener listener : this.containerLifecycleListeners) {
            listener.onStartup(container);
        }
    }

    @Override
    public void onReload(Container container) {
        for (ContainerLifecycleListener listener : this.containerLifecycleListeners) {
            listener.onReload(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShutdown(Container container) {
        try {
            for (ContainerLifecycleListener listener : this.containerLifecycleListeners) {
                listener.onShutdown(container);
            }
        }
        finally {
            try {
                this.injectionManager.preDestroy((Object)ResourceConfig.unwrapApplication(this.application));
            }
            finally {
                this.injectionManager.shutdown();
            }
        }
    }

    private static class FutureResponseWriter
    extends AbstractFuture<ContainerResponse>
    implements ContainerResponseWriter {
        private ContainerResponse response = null;
        private final String requestMethodName;
        private final OutputStream outputStream;
        private final JerseyRequestTimeoutHandler requestTimeoutHandler;

        private FutureResponseWriter(String requestMethodName, OutputStream outputStream, ScheduledExecutorService backgroundScheduler) {
            this.requestMethodName = requestMethodName;
            this.outputStream = outputStream;
            this.requestTimeoutHandler = new JerseyRequestTimeoutHandler(this, backgroundScheduler);
        }

        @Override
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse response) {
            this.response = response;
            if (contentLength >= 0L) {
                response.getHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
            }
            return this.outputStream;
        }

        @Override
        public boolean suspend(long time, TimeUnit unit, ContainerResponseWriter.TimeoutHandler handler) {
            return this.requestTimeoutHandler.suspend(time, unit, handler);
        }

        @Override
        public void setSuspendTimeout(long time, TimeUnit unit) {
            this.requestTimeoutHandler.setSuspendTimeout(time, unit);
        }

        @Override
        public void commit() {
            ContainerResponse current = this.response;
            if (current != null) {
                if ("HEAD".equals(this.requestMethodName) && current.hasEntity()) {
                    current.setEntity(null);
                }
                this.requestTimeoutHandler.close();
                super.set((Object)current);
            }
        }

        @Override
        public void failure(Throwable error) {
            this.requestTimeoutHandler.close();
            super.setException(error);
        }

        @Override
        public boolean enableResponseBuffering() {
            return true;
        }

        protected void interruptTask() {
        }
    }

    private static class WorkersToStringTransform<T>
    implements Function<T, String> {
        private WorkersToStringTransform() {
        }

        public String apply(T t) {
            if (t != null) {
                return t.getClass().getName();
            }
            return null;
        }
    }

    private class ApplicationBinder
    extends AbstractBinder {
        private ApplicationBinder() {
        }

        protected void configure() {
            ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(new RuntimeConfigProvider()).to(ServerConfig.class)).to(Configuration.class)).in(Singleton.class);
            ((SupplierInstanceBinding)this.bindFactory(new JaxrsApplicationProvider()).to(Application.class)).in(Singleton.class);
            this.bind(ApplicationHandler.this).to(ApplicationHandler.class);
        }

        private class RuntimeConfigProvider
        implements Supplier<ServerConfig> {
            private RuntimeConfigProvider() {
            }

            @Override
            public ServerConfig get() {
                return ApplicationHandler.this.runtimeConfig;
            }
        }

        private class JaxrsApplicationProvider
        implements Supplier<Application> {
            private JaxrsApplicationProvider() {
            }

            @Override
            public Application get() {
                return ApplicationHandler.this.application;
            }
        }
    }
}

