/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.ws.rs.container.ResourceContext;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.CustomAnnotationLiteral;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ExtendedResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.ResourceModel;

public class JerseyResourceContext
implements ExtendedResourceContext {
    private final InjectionManager injectionManager;
    private final Set<Class<?>> bindingCache;
    private final Object bindingCacheLock;
    private volatile ResourceModel resourceModel;

    @Inject
    JerseyResourceContext(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
        this.bindingCache = Sets.newIdentityHashSet();
        this.bindingCacheLock = new Object();
    }

    public <T> T getResource(Class<T> resourceClass) {
        try {
            return (T)Injections.getOrCreate((InjectionManager)this.injectionManager, resourceClass);
        }
        catch (Exception ex) {
            Logger.getLogger(JerseyResourceContext.class.getName()).log(Level.WARNING, LocalizationMessages.RESOURCE_LOOKUP_FAILED(resourceClass), ex);
            return null;
        }
    }

    public <T> T initResource(T resource) {
        this.injectionManager.inject(resource);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void bindResource(Class<T> resourceClass) {
        if (this.bindingCache.contains(resourceClass)) {
            return;
        }
        Object object = this.bindingCacheLock;
        synchronized (object) {
            if (this.bindingCache.contains(resourceClass)) {
                return;
            }
            this.unsafeBindResource(resourceClass, null, this.injectionManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void bindResourceIfSingleton(final T resource) {
        final Class<?> resourceClass = resource.getClass();
        if (this.bindingCache.contains(resourceClass)) {
            return;
        }
        Object object = this.bindingCacheLock;
        synchronized (object) {
            if (this.bindingCache.contains(resourceClass)) {
                return;
            }
            if (JerseyResourceContext.getScope(resourceClass) == Singleton.class) {
                AbstractBinder binder = new AbstractBinder(){

                    protected void configure() {
                        this.bind(resource).to(resourceClass);
                    }
                };
                this.injectionManager.register((org.glassfish.jersey.internal.inject.Binder)binder);
            }
            this.bindingCache.add(resourceClass);
        }
    }

    public void unsafeBindResource(Object resource, ContractProvider providerModel, InjectionManager injectionManager) {
        ClassBinding binding;
        Class<?> resourceClass = resource.getClass();
        if (providerModel != null) {
            Class scope = providerModel.getScope();
            binding = Bindings.service((Object)resource).to(resourceClass);
            for (Class contract : Providers.getProviderContracts(resourceClass)) {
                binding.addAlias(contract.getName()).in(scope.getName()).qualifiedBy((Annotation)CustomAnnotationLiteral.INSTANCE);
            }
        } else {
            binding = Bindings.serviceAsContract(resourceClass);
        }
        injectionManager.register((Binding)binding);
        this.bindingCache.add(resourceClass);
    }

    private static Class<? extends Annotation> getScope(Class<?> resourceClass) {
        Collection scopes = ReflectionHelper.getAnnotationTypes(resourceClass, Scope.class);
        return scopes.isEmpty() ? RequestScoped.class : (Class)scopes.iterator().next();
    }

    public <T> void unsafeBindResource(Class<T> resourceClass, ContractProvider providerModel, InjectionManager injectionManager) {
        ClassBinding descriptor;
        if (providerModel != null) {
            Class scope = providerModel.getScope();
            descriptor = (ClassBinding)Bindings.serviceAsContract(resourceClass).in(scope);
            for (Class contract : providerModel.getContracts()) {
                descriptor.addAlias(contract.getName()).in(scope.getName()).ranked(providerModel.getPriority(contract)).qualifiedBy((Annotation)CustomAnnotationLiteral.INSTANCE);
            }
        } else {
            descriptor = (ClassBinding)Bindings.serviceAsContract(resourceClass).in(JerseyResourceContext.getScope(resourceClass));
        }
        injectionManager.register((Binding)descriptor);
        this.bindingCache.add(resourceClass);
    }

    @Override
    public ResourceModel getResourceModel() {
        return this.resourceModel;
    }

    public void setResourceModel(ResourceModel resourceModel) {
        this.resourceModel = resourceModel;
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bindAsContract(JerseyResourceContext.class).to(ResourceContext.class)).to(ExtendedResourceContext.class)).in(Singleton.class);
        }
    }
}

