/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.function.Supplier;
import javax.inject.Provider;
import javax.ws.rs.container.AsyncResponse;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueSupplierProvider;

final class AsyncResponseValueSupplierProvider
implements ValueSupplierProvider {
    private final Provider<AsyncContext> asyncContextProvider;

    public AsyncResponseValueSupplierProvider(Provider<AsyncContext> asyncContextProvider) {
        this.asyncContextProvider = asyncContextProvider;
    }

    public Supplier<AsyncResponse> getValueSupplier(Parameter parameter) {
        if (parameter.getSource() != Parameter.Source.SUSPENDED) {
            return null;
        }
        if (!AsyncResponse.class.isAssignableFrom(parameter.getRawType())) {
            return null;
        }
        return () -> this.asyncContextProvider.get();
    }

    @Override
    public ValueSupplierProvider.PriorityType getPriority() {
        return ValueSupplierProvider.Priority.NORMAL;
    }
}

