/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.function.Function;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.Cache;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.AbstractRequestDerivedValueSupplier;
import org.glassfish.jersey.server.internal.inject.AbstractValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class BeanParamValueSupplierProvider
extends AbstractValueSupplierProvider {
    private final InjectionManager injectionManager;

    public BeanParamValueSupplierProvider(MultivaluedParameterExtractorProvider mpep, Provider<ContainerRequest> requestProvider, InjectionManager injectionManager) {
        super(mpep, requestProvider, Parameter.Source.BEAN_PARAM);
        this.injectionManager = injectionManager;
    }

    @Override
    public AbstractRequestDerivedValueSupplier<?> createValueSupplier(Parameter parameter, Provider<ContainerRequest> requestProvider) {
        return new BeanParamValueSupplier(this.injectionManager, parameter, requestProvider);
    }

    private static final class BeanParamValueSupplier
    extends AbstractRequestDerivedValueSupplier<Object> {
        private final Parameter parameter;
        private final InjectionManager injectionManager;
        private final Cache<Class<?>, ForeignDescriptor> descriptorCache = new Cache(new Function<Class<?>, ForeignDescriptor>(){

            @Override
            public ForeignDescriptor apply(Class<?> key) {
                return injectionManager.createForeignDescriptor(Bindings.serviceAsContract(key).in(RequestScoped.class));
            }
        });

        private BeanParamValueSupplier(InjectionManager injectionManager, Parameter parameter, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.injectionManager = injectionManager;
            this.parameter = parameter;
        }

        @Override
        public Object get() {
            Class<?> rawType = this.parameter.getRawType();
            Object fromHk2 = this.injectionManager.getInstance(rawType);
            if (fromHk2 != null) {
                return fromHk2;
            }
            ForeignDescriptor foreignDescriptor = (ForeignDescriptor)this.descriptorCache.apply(rawType);
            return this.injectionManager.getInstance(foreignDescriptor);
        }
    }
}

