/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.Map;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractRequestDerivedValueSupplier;
import org.glassfish.jersey.server.internal.inject.AbstractValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class CookieParamValueSupplierProvider
extends AbstractValueSupplierProvider {
    public CookieParamValueSupplierProvider(MultivaluedParameterExtractorProvider mpep, Provider<ContainerRequest> requestProvider) {
        super(mpep, requestProvider, Parameter.Source.COOKIE);
    }

    @Override
    public AbstractRequestDerivedValueSupplier<?> createValueSupplier(Parameter parameter, Provider<ContainerRequest> requestProvider) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        if (parameter.getRawType() == Cookie.class) {
            return new CookieTypeParamValueSupplier(parameterName, requestProvider);
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new CookieParamValueSupplier(e, requestProvider);
    }

    private static final class CookieTypeParamValueSupplier
    extends AbstractRequestDerivedValueSupplier<Cookie> {
        private final String name;

        CookieTypeParamValueSupplier(String name, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.name = name;
        }

        @Override
        public Cookie get() {
            return this.getRequest().getCookies().get(this.name);
        }
    }

    private static final class CookieParamValueSupplier
    extends AbstractRequestDerivedValueSupplier<Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        CookieParamValueSupplier(MultivaluedParameterExtractor<?> extractor, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.extractor = extractor;
        }

        @Override
        public Object get() {
            MultivaluedStringMap cookies = new MultivaluedStringMap();
            for (Map.Entry<String, Cookie> e : this.getRequest().getCookies().entrySet()) {
                cookies.putSingle((Object)e.getKey(), (Object)e.getValue().getValue());
            }
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)cookies);
            }
            catch (ExtractorException ex) {
                throw new ParamException.CookieParamException(ex.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

