/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.AbstractRequestDerivedValueSupplier;
import org.glassfish.jersey.server.internal.inject.AbstractValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
class EntityParamValueSupplierProvider
extends AbstractValueSupplierProvider {
    EntityParamValueSupplierProvider(MultivaluedParameterExtractorProvider mpep, Provider<ContainerRequest> requestProvider) {
        super(mpep, requestProvider, Parameter.Source.ENTITY);
    }

    @Override
    protected AbstractRequestDerivedValueSupplier<?> createValueSupplier(Parameter parameter, Provider<ContainerRequest> requestProvider) {
        return new EntityValueSupplier(parameter, requestProvider);
    }

    private static class EntityValueSupplier
    extends AbstractRequestDerivedValueSupplier<Object> {
        private final Parameter parameter;

        public EntityValueSupplier(Parameter parameter, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.parameter = parameter;
        }

        @Override
        public Object get() {
            ContainerRequest value;
            ContainerRequest requestContext = this.getRequest();
            Class<?> rawType = this.parameter.getRawType();
            if ((Request.class.isAssignableFrom(rawType) || ContainerRequestContext.class.isAssignableFrom(rawType)) && rawType.isInstance((Object)requestContext)) {
                value = requestContext;
            } else {
                value = requestContext.readEntity(rawType, this.parameter.getType(), this.parameter.getAnnotations());
                if (rawType.isPrimitive() && value == null) {
                    throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)LocalizationMessages.ERROR_PRIMITIVE_TYPE_NULL()).build());
                }
            }
            return value;
        }
    }
}

