/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractRequestDerivedValueSupplier;
import org.glassfish.jersey.server.internal.inject.AbstractValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class HeaderParamValueSupplierProvider
extends AbstractValueSupplierProvider {
    public HeaderParamValueSupplierProvider(MultivaluedParameterExtractorProvider mpep, Provider<ContainerRequest> requestProvider) {
        super(mpep, requestProvider, Parameter.Source.HEADER);
    }

    @Override
    public AbstractRequestDerivedValueSupplier<?> createValueSupplier(Parameter parameter, Provider<ContainerRequest> requestProvider) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new HeaderParamValueSupplier(e, requestProvider);
    }

    private static final class HeaderParamValueSupplier
    extends AbstractRequestDerivedValueSupplier<Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        HeaderParamValueSupplier(MultivaluedParameterExtractor<?> extractor, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.extractor = extractor;
        }

        @Override
        public Object get() {
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)this.getRequest().getHeaders());
            }
            catch (ExtractorException e) {
                throw new ParamException.HeaderParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

