/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.List;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractRequestDerivedValueSupplier;
import org.glassfish.jersey.server.internal.inject.AbstractValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class MatrixParamValueSupplierProvider
extends AbstractValueSupplierProvider {
    public MatrixParamValueSupplierProvider(MultivaluedParameterExtractorProvider mpep, Provider<ContainerRequest> requestProvider) {
        super(mpep, requestProvider, Parameter.Source.MATRIX);
    }

    @Override
    public AbstractRequestDerivedValueSupplier<?> createValueSupplier(Parameter parameter, Provider<ContainerRequest> requestProvider) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new MatrixParamValueSupplier(e, !parameter.isEncoded(), requestProvider);
    }

    private static final class MatrixParamValueSupplier
    extends AbstractRequestDerivedValueSupplier<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;

        MatrixParamValueSupplier(MultivaluedParameterExtractor<?> extractor, boolean decode, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        public Object get() {
            List l = this.getRequest().getUriInfo().getPathSegments(this.decode);
            PathSegment p = (PathSegment)l.get(l.size() - 1);
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)p.getMatrixParameters());
            }
            catch (ExtractorException e) {
                throw new ParamException.MatrixParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

