/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.function.Function;
import javax.inject.Provider;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.ParamConverterProvider;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.Uri;
import org.glassfish.jersey.server.internal.inject.AsyncResponseValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.BeanParamValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.CookieParamValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.DelegatedInjectionValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.EntityParamValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.FormParamValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.HeaderParamValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.MatrixParamValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorFactory;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamConverterFactory;
import org.glassfish.jersey.server.internal.inject.ParamConverters;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.internal.inject.PathParamValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.QueryParamValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.WebTargetValueSupplierProvider;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.spi.internal.ValueSupplierProvider;

public class ParameterInjectionBinder
extends AbstractBinder {
    private final InjectionManager injectionManager;

    public ParameterInjectionBinder(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
    }

    public void configure() {
        this.bind(new ParamConverters.AggregatedProvider()).to(ParamConverterProvider.class);
        Provider requestProvider = Injections.getProvider((InjectionManager)this.injectionManager, ContainerRequest.class);
        Provider asyncContextProvider = Injections.getProvider((InjectionManager)this.injectionManager, AsyncContext.class);
        Function<Class<? extends Configuration>, Configuration> clientConfigProvider = clientConfigClass -> (Configuration)Injections.getOrCreate((InjectionManager)this.injectionManager, (Class)clientConfigClass);
        LazyValue lazyParamConverterFactory = Values.lazy(() -> new ParamConverterFactory(Providers.getProviders((InjectionManager)this.injectionManager, ParamConverterProvider.class), Providers.getCustomProviders((InjectionManager)this.injectionManager, ParamConverterProvider.class)));
        LazyValue lazyConfiguration = Values.lazy(() -> (Configuration)this.injectionManager.getInstance(Configuration.class));
        MultivaluedParameterExtractorFactory paramExtractor = new MultivaluedParameterExtractorFactory((LazyValue<ParamConverterFactory>)lazyParamConverterFactory);
        this.bind(paramExtractor).to(MultivaluedParameterExtractorProvider.class);
        AsyncResponseValueSupplierProvider asyncSupplier = new AsyncResponseValueSupplierProvider((Provider<AsyncContext>)asyncContextProvider);
        this.bindValueSupplier(asyncSupplier);
        CookieParamValueSupplierProvider cookieSupplier = new CookieParamValueSupplierProvider(paramExtractor, (Provider<ContainerRequest>)requestProvider);
        this.bindValueSupplier(cookieSupplier);
        EntityParamValueSupplierProvider entitySupplier = new EntityParamValueSupplierProvider(paramExtractor, (Provider<ContainerRequest>)requestProvider);
        this.bindValueSupplier(entitySupplier);
        FormParamValueSupplierProvider formSupplier = new FormParamValueSupplierProvider(paramExtractor, (Provider<ContainerRequest>)requestProvider);
        this.bindValueSupplier(formSupplier);
        HeaderParamValueSupplierProvider headerSupplier = new HeaderParamValueSupplierProvider(paramExtractor, (Provider<ContainerRequest>)requestProvider);
        this.bindValueSupplier(headerSupplier);
        MatrixParamValueSupplierProvider matrixSupplier = new MatrixParamValueSupplierProvider(paramExtractor, (Provider<ContainerRequest>)requestProvider);
        this.bindValueSupplier(matrixSupplier);
        PathParamValueSupplierProvider pathSupplier = new PathParamValueSupplierProvider(paramExtractor, (Provider<ContainerRequest>)requestProvider);
        this.bindValueSupplier(pathSupplier);
        QueryParamValueSupplierProvider querySupplier = new QueryParamValueSupplierProvider(paramExtractor, (Provider<ContainerRequest>)requestProvider);
        this.bindValueSupplier(querySupplier);
        WebTargetValueSupplierProvider webTargetSupplier = new WebTargetValueSupplierProvider((Provider<ContainerRequest>)requestProvider, (LazyValue<Configuration>)lazyConfiguration, clientConfigProvider);
        this.bindValueSupplier(webTargetSupplier);
        BeanParamValueSupplierProvider beanSupplier = new BeanParamValueSupplierProvider((MultivaluedParameterExtractorProvider)paramExtractor, (Provider<ContainerRequest>)requestProvider, this.injectionManager);
        this.bindValueSupplier(beanSupplier);
        this.bind(new ParamInjectionResolver<CookieParam>(cookieSupplier, CookieParam.class));
        this.bind(new ParamInjectionResolver<FormParam>(formSupplier, FormParam.class));
        this.bind(new ParamInjectionResolver<HeaderParam>(headerSupplier, HeaderParam.class));
        this.bind(new ParamInjectionResolver<MatrixParam>(matrixSupplier, MatrixParam.class));
        this.bind(new ParamInjectionResolver<QueryParam>(querySupplier, QueryParam.class));
        this.bind(new ParamInjectionResolver<PathParam>(pathSupplier, PathParam.class));
        this.bind(new ParamInjectionResolver<Suspended>(asyncSupplier, Suspended.class));
        this.bind(new ParamInjectionResolver<Uri>(webTargetSupplier, Uri.class));
        this.bind(new ParamInjectionResolver<BeanParam>(beanSupplier, BeanParam.class));
        ContextInjectionResolver contextInjectionResolver = (ContextInjectionResolver)this.injectionManager.getInstance(ContextInjectionResolver.class);
        this.bind(new DelegatedInjectionValueSupplierProvider(contextInjectionResolver, arg_0 -> ((InjectionManager)this.injectionManager).createForeignDescriptor(arg_0))).to(ValueSupplierProvider.class);
    }

    private <T extends ValueSupplierProvider> void bindValueSupplier(T supplier) {
        this.bind(supplier).to(ValueSupplierProvider.class);
    }
}

