/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractRequestDerivedValueSupplier;
import org.glassfish.jersey.server.internal.inject.AbstractValueSupplierProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class PathParamValueSupplierProvider
extends AbstractValueSupplierProvider {
    public PathParamValueSupplierProvider(MultivaluedParameterExtractorProvider mpep, Provider<ContainerRequest> requestProvider) {
        super(mpep, requestProvider, Parameter.Source.PATH);
    }

    @Override
    public AbstractRequestDerivedValueSupplier<?> createValueSupplier(Parameter parameter, Provider<ContainerRequest> requestProvider) {
        ParameterizedType pt;
        Type[] targs;
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        Class<?> rawParameterType = parameter.getRawType();
        if (rawParameterType == PathSegment.class) {
            return new PathParamPathSegmentValueSupplier(parameterName, !parameter.isEncoded(), requestProvider);
        }
        if (rawParameterType == List.class && parameter.getType() instanceof ParameterizedType && (targs = (pt = (ParameterizedType)parameter.getType()).getActualTypeArguments()).length == 1 && targs[0] == PathSegment.class) {
            return new PathParamListPathSegmentValueSupplier(parameterName, !parameter.isEncoded(), requestProvider);
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new PathParamValueSupplier(e, !parameter.isEncoded(), requestProvider);
    }

    private static final class PathParamListPathSegmentValueSupplier
    extends AbstractRequestDerivedValueSupplier<List<PathSegment>> {
        private final String name;
        private final boolean decode;

        PathParamListPathSegmentValueSupplier(String name, boolean decode, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.name = name;
            this.decode = decode;
        }

        @Override
        public List<PathSegment> get() {
            return this.getRequest().getUriInfo().getPathSegments(this.name, this.decode);
        }
    }

    private static final class PathParamPathSegmentValueSupplier
    extends AbstractRequestDerivedValueSupplier<PathSegment> {
        private final String name;
        private final boolean decode;

        PathParamPathSegmentValueSupplier(String name, boolean decode, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.name = name;
            this.decode = decode;
        }

        @Override
        public PathSegment get() {
            List<PathSegment> ps = this.getRequest().getUriInfo().getPathSegments(this.name, this.decode);
            if (ps.isEmpty()) {
                return null;
            }
            return ps.get(ps.size() - 1);
        }
    }

    private static final class PathParamValueSupplier
    extends AbstractRequestDerivedValueSupplier<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;

        PathParamValueSupplier(MultivaluedParameterExtractor<?> extractor, boolean decode, Provider<ContainerRequest> requestProvider) {
            super(requestProvider);
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        public Object get() {
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)this.getRequest().getUriInfo().getPathParameters(this.decode));
            }
            catch (ExtractorException e) {
                throw new ParamException.PathParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }
}

