/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.ProcessingProviders;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.MatchedEndpointExtractorStage;
import org.glassfish.jersey.server.internal.routing.RoutingStage;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.server.model.RuntimeResourceModel;

public final class Routing {
    private Routing() {
        throw new AssertionError((Object)"No instances allowed.");
    }

    public static Stage<RequestProcessingContext> matchedEndpointExtractor() {
        return new MatchedEndpointExtractorStage();
    }

    public static Builder forModel(RuntimeResourceModel resourceModel) {
        return new Builder(resourceModel);
    }

    public static final class Builder {
        private final RuntimeResourceModel resourceModel;
        private InjectionManager injectionManager;
        private JerseyResourceContext resourceContext;
        private Configuration config;
        private MessageBodyWorkers entityProviders;
        private ProcessingProviders processingProviders;

        private Builder(RuntimeResourceModel resourceModel) {
            if (resourceModel == null) {
                throw new NullPointerException("Resource model must not be null.");
            }
            this.resourceModel = resourceModel;
        }

        public Builder beanManager(InjectionManager injectionManager) {
            this.injectionManager = injectionManager;
            return this;
        }

        public Builder resourceContext(JerseyResourceContext resourceContext) {
            this.resourceContext = resourceContext;
            return this;
        }

        public Builder configuration(Configuration config) {
            this.config = config;
            return this;
        }

        public Builder entityProviders(MessageBodyWorkers workers) {
            this.entityProviders = workers;
            return this;
        }

        public Builder processingProviders(ProcessingProviders processingProviders) {
            this.processingProviders = processingProviders;
            return this;
        }

        public ChainableStage<RequestProcessingContext> buildStage() {
            if (this.injectionManager == null) {
                throw new NullPointerException("DI injection manager is not set.");
            }
            if (this.resourceContext == null) {
                throw new NullPointerException("Resource context is not set.");
            }
            if (this.config == null) {
                throw new NullPointerException("Runtime configuration is not set.");
            }
            if (this.entityProviders == null) {
                throw new NullPointerException("Entity providers are not set.");
            }
            if (this.processingProviders == null) {
                throw new NullPointerException("Processing providers are not set.");
            }
            RuntimeModelBuilder runtimeModelBuilder = new RuntimeModelBuilder(this.injectionManager, this.resourceContext, this.config, this.entityProviders, this.processingProviders, (ResourceMethodInvoker.Builder)this.injectionManager.getInstance(ResourceMethodInvoker.Builder.class));
            return new RoutingStage(runtimeModelBuilder.buildModel(this.resourceModel, false));
        }
    }
}

