/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.sse.SseEventSink;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.AbstractResourceModelVisitor;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.ResourceMethod;

class ResourceMethodValidator
extends AbstractResourceModelVisitor {
    private final InjectionManager injectionManager;
    private static final Set<Class> PARAM_ANNOTATION_SET = ResourceMethodValidator.createParamAnnotationSet();

    public ResourceMethodValidator(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
    }

    @Override
    public void visitResourceMethod(ResourceMethod method) {
        switch (method.getType()) {
            case RESOURCE_METHOD: {
                this.visitJaxrsResourceMethod(method);
                break;
            }
            case SUB_RESOURCE_LOCATOR: {
                this.visitSubResourceLocator(method);
            }
        }
    }

    private void visitJaxrsResourceMethod(ResourceMethod method) {
        this.checkMethod(method);
    }

    private void checkMethod(ResourceMethod method) {
        String path;
        Path pathAnnotation;
        Type responseType;
        this.checkValueProviders(method);
        Invocable invocable = method.getInvocable();
        this.checkParameters(method);
        if ("GET".equals(method.getHttpMethod())) {
            int isSse;
            long eventSinkCount = invocable.getParameters().stream().filter(parameter -> SseEventSink.class.equals(parameter.getRawType())).count();
            int n = isSse = eventSinkCount > 0L ? 1 : 0;
            if (eventSinkCount > 1L) {
                Errors.warning((Object)method, (String)LocalizationMessages.MULTIPLE_EVENT_SINK_INJECTION(invocable.getHandlingMethod()));
            }
            if (Void.TYPE == invocable.getHandlingMethod().getReturnType() && !method.isSuspendDeclared() && isSse == 0) {
                Errors.hint((Object)method, (String)LocalizationMessages.GET_RETURNS_VOID(invocable.getHandlingMethod()));
            }
            if (invocable.requiresEntity() && !invocable.isInflector()) {
                Errors.warning((Object)method, (String)LocalizationMessages.GET_CONSUMES_ENTITY(invocable.getHandlingMethod()));
            }
            for (Parameter p : invocable.getParameters()) {
                if (!p.isAnnotationPresent(FormParam.class)) continue;
                Errors.fatal((Object)method, (String)LocalizationMessages.GET_CONSUMES_FORM_PARAM(invocable.getHandlingMethod()));
                break;
            }
            if (isSse != 0 && Void.TYPE != invocable.getHandlingMethod().getReturnType()) {
                Errors.fatal((Object)method, (String)LocalizationMessages.EVENT_SINK_RETURNS_TYPE(invocable.getHandlingMethod()));
            }
        }
        LinkedList<String> httpMethodAnnotations = new LinkedList<String>();
        for (Annotation a : invocable.getHandlingMethod().getDeclaredAnnotations()) {
            if (null == a.annotationType().getAnnotation(HttpMethod.class)) continue;
            httpMethodAnnotations.add(a.toString());
        }
        if (httpMethodAnnotations.size() > 1) {
            Errors.fatal((Object)method, (String)LocalizationMessages.MULTIPLE_HTTP_METHOD_DESIGNATORS(invocable.getHandlingMethod(), ((Object)httpMethodAnnotations).toString()));
        }
        if (!ResourceMethodValidator.isConcreteType(responseType = invocable.getResponseType())) {
            Errors.warning((Object)invocable.getHandlingMethod(), (String)LocalizationMessages.TYPE_OF_METHOD_NOT_RESOLVABLE_TO_CONCRETE_TYPE(responseType, invocable.getHandlingMethod().toGenericString()));
        }
        if ((pathAnnotation = invocable.getHandlingMethod().getAnnotation(Path.class)) != null && ((path = pathAnnotation.value()) == null || path.isEmpty() || "/".equals(path))) {
            Errors.warning((Object)invocable.getHandlingMethod(), (String)LocalizationMessages.METHOD_EMPTY_PATH_ANNOTATION(invocable.getHandlingMethod().getName(), invocable.getHandler().getHandlerClass().getName()));
        }
    }

    private void checkValueProviders(ResourceMethod method) {
        List<Supplier<?>> valueProviders = method.getInvocable().getValueProviders(this.injectionManager);
        if (valueProviders.contains(null)) {
            int index = valueProviders.indexOf(null);
            Errors.fatal((Object)method, (String)LocalizationMessages.ERROR_PARAMETER_MISSING_VALUE_PROVIDER(index, method.getInvocable().getHandlingMethod()));
        }
    }

    private void visitSubResourceLocator(ResourceMethod locator) {
        this.checkParameters(locator);
        this.checkValueProviders(locator);
        Invocable invocable = locator.getInvocable();
        if (Void.TYPE == invocable.getRawResponseType()) {
            Errors.fatal((Object)locator, (String)LocalizationMessages.SUBRES_LOC_RETURNS_VOID(invocable.getHandlingMethod()));
        }
    }

    private void checkParameters(ResourceMethod method) {
        Invocable invocable = method.getInvocable();
        Method handlingMethod = invocable.getHandlingMethod();
        int paramCount = 0;
        int nonAnnotatedParameters = 0;
        for (Parameter p : invocable.getParameters()) {
            ResourceMethodValidator.validateParameter(p, handlingMethod, handlingMethod.toGenericString(), Integer.toString(++paramCount), false);
            if (method.getType() == ResourceMethod.JaxrsType.SUB_RESOURCE_LOCATOR && Parameter.Source.ENTITY == p.getSource()) {
                Errors.fatal((Object)method, (String)LocalizationMessages.SUBRES_LOC_HAS_ENTITY_PARAM(invocable.getHandlingMethod()));
                continue;
            }
            if (p.getAnnotations().length != 0 || ++nonAnnotatedParameters <= 1) continue;
            Errors.fatal((Object)method, (String)LocalizationMessages.AMBIGUOUS_NON_ANNOTATED_PARAMETER(invocable.getHandlingMethod(), invocable.getHandlingMethod().getDeclaringClass()));
        }
    }

    private boolean isSseInjected(Invocable invocable) {
        return invocable.getParameters().stream().anyMatch(parameter -> SseEventSink.class.equals(parameter.getRawType()));
    }

    private static Set<Class> createParamAnnotationSet() {
        HashSet<Class> set = new HashSet<Class>(6);
        set.add(HeaderParam.class);
        set.add(CookieParam.class);
        set.add(MatrixParam.class);
        set.add(QueryParam.class);
        set.add(PathParam.class);
        set.add(BeanParam.class);
        return Collections.unmodifiableSet(set);
    }

    static void validateParameter(final Parameter parameter, final Object source, final String reportedSourceName, final String reportedParameterName, final boolean injectionsForbidden) {
        Errors.processWithException((Runnable)new Runnable(){

            @Override
            public void run() {
                Type paramType;
                Annotation[] annotations;
                int counter = 0;
                for (Annotation a : annotations = parameter.getAnnotations()) {
                    if (!PARAM_ANNOTATION_SET.contains(a.annotationType())) continue;
                    if (injectionsForbidden) {
                        Errors.fatal((Object)source, (String)LocalizationMessages.SINGLETON_INJECTS_PARAMETER(reportedSourceName, reportedParameterName));
                        break;
                    }
                    if (++counter <= 1) continue;
                    Errors.warning((Object)source, (String)LocalizationMessages.AMBIGUOUS_PARAMETER(reportedSourceName, reportedParameterName));
                    break;
                }
                if (!ResourceMethodValidator.isConcreteType(paramType = parameter.getType())) {
                    Errors.warning((Object)source, (String)LocalizationMessages.PARAMETER_UNRESOLVABLE(reportedParameterName, paramType, reportedSourceName));
                }
            }
        });
    }

    private static boolean isConcreteType(Type t) {
        if (t instanceof ParameterizedType) {
            return ResourceMethodValidator.isConcreteParameterizedType((ParameterizedType)t);
        }
        return t instanceof Class;
    }

    private static boolean isConcreteParameterizedType(ParameterizedType pt) {
        boolean isConcrete = true;
        for (Type t : pt.getActualTypeArguments()) {
            isConcrete &= ResourceMethodValidator.isConcreteType(t);
        }
        return isConcrete;
    }
}

