/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import java.lang.reflect.InvocationHandler;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

@Singleton
public final class ResourceMethodInvocationHandlerFactory
implements ResourceMethodInvocationHandlerProvider {
    private static final InvocationHandler DEFAULT_HANDLER = (target, method, args) -> method.invoke(target, args);
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodInvocationHandlerFactory.class.getName());
    private final Set<ResourceMethodInvocationHandlerProvider> providers;

    @Inject
    ResourceMethodInvocationHandlerFactory(InjectionManager injectionManager) {
        this.providers = Providers.getProviders((InjectionManager)injectionManager, ResourceMethodInvocationHandlerProvider.class);
    }

    @Override
    public InvocationHandler create(Invocable resourceMethod) {
        for (ResourceMethodInvocationHandlerProvider provider : this.providers) {
            try {
                InvocationHandler handler = provider.create(resourceMethod);
                if (handler == null) continue;
                return handler;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_PROCESSING_METHOD(resourceMethod, provider.getClass().getName()), e);
            }
        }
        return DEFAULT_HANDLER;
    }
}

