/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spi.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.spi.internal.ParamValueFactoryWithSource;
import org.glassfish.jersey.server.spi.internal.ValueSupplierProvider;

public final class ParameterValueHelper {
    public static Object[] getParameterValues(List<ParamValueFactoryWithSource<?>> valueProviders) {
        Object[] params = new Object[valueProviders.size()];
        try {
            int entityProviderIndex = -1;
            int index = 0;
            for (ParamValueFactoryWithSource<?> paramValProvider : valueProviders) {
                if (paramValProvider.getSource().equals((Object)Parameter.Source.ENTITY)) {
                    entityProviderIndex = index++;
                    continue;
                }
                params[index++] = paramValProvider.get();
            }
            if (entityProviderIndex != -1) {
                params[entityProviderIndex] = valueProviders.get(entityProviderIndex).get();
            }
            return params;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (MessageBodyProviderNotFoundException e) {
            throw new NotSupportedException((Throwable)e);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            throw new MappableException("Exception obtaining parameters", e);
        }
    }

    public static List<ParamValueFactoryWithSource<?>> createValueProviders(InjectionManager injectionManager, Parameterized parameterized) {
        Supplier<?> valueSupplier;
        if (null == parameterized.getParameters() || 0 == parameterized.getParameters().size()) {
            return Collections.emptyList();
        }
        List<ValueSupplierProvider> valueSupplierProviders = Providers.getProviders((InjectionManager)injectionManager, ValueSupplierProvider.class).stream().sorted((o1, o2) -> o2.getPriority().getWeight() - o1.getPriority().getWeight()).collect(Collectors.toList());
        boolean entityParamFound = false;
        ArrayList providers = new ArrayList(parameterized.getParameters().size());
        for (Parameter parameter : parameterized.getParameters()) {
            Parameter.Source parameterSource = parameter.getSource();
            entityParamFound = entityParamFound || Parameter.Source.ENTITY == parameterSource;
            valueSupplier = ParameterValueHelper.getParamValueSupplier(valueSupplierProviders, parameter);
            if (valueSupplier != null) {
                providers.add(ParameterValueHelper.wrapParamValueSupplier(valueSupplier, parameterSource));
                continue;
            }
            providers.add(null);
        }
        if (!entityParamFound && Collections.frequency(providers, null) == 1) {
            Parameter parameter;
            int entityParamIndex = providers.lastIndexOf(null);
            parameter = parameterized.getParameters().get(entityParamIndex);
            if (Parameter.Source.UNKNOWN == parameter.getSource() && !parameter.isQualified()) {
                Parameter overriddenParameter = Parameter.overrideSource(parameter, Parameter.Source.ENTITY);
                valueSupplier = ParameterValueHelper.getParamValueSupplier(valueSupplierProviders, overriddenParameter);
                if (valueSupplier != null) {
                    providers.set(entityParamIndex, ParameterValueHelper.wrapParamValueSupplier(valueSupplier, overriddenParameter.getSource()));
                } else {
                    providers.set(entityParamIndex, null);
                }
            }
        }
        return providers;
    }

    private static <T> ParamValueFactoryWithSource<T> wrapParamValueSupplier(Supplier<T> factory, Parameter.Source paramSource) {
        return new ParamValueFactoryWithSource<T>(factory, paramSource);
    }

    private static Supplier<?> getParamValueSupplier(Collection<ValueSupplierProvider> valueSupplierProviders, Parameter parameter) {
        Supplier<?> paramValueSupplier = null;
        Iterator<ValueSupplierProvider> vfpIterator = valueSupplierProviders.iterator();
        while (paramValueSupplier == null && vfpIterator.hasNext()) {
            paramValueSupplier = vfpIterator.next().getValueSupplier(parameter);
        }
        return paramValueSupplier;
    }

    private ParameterValueHelper() {
    }
}

