/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.spi.WebServer;

public final class JerseySeBootstrapConfiguration
implements SeBootstrap.Configuration {
    private static final Logger LOGGER = Logger.getLogger(JerseySeBootstrapConfiguration.class.getName());
    private final SeBootstrap.Configuration configuration;

    private JerseySeBootstrapConfiguration(SeBootstrap.Configuration configuration) {
        this.configuration = configuration;
    }

    public Object property(String name) {
        return this.configuration.property(name);
    }

    public URI uri(boolean resolveDefaultPort) {
        String protocol = this.configuration.protocol();
        String host = this.configuration.host();
        int configPort = this.configuration.port();
        int port = configPort < 0 && resolveDefaultPort ? (this.isHttps() ? 443 : 80) : configPort;
        String rootPath = this.configuration.rootPath();
        URI uri = UriBuilder.newInstance().scheme(protocol.toLowerCase()).host(host).port(port).path(rootPath).build(new Object[0]);
        return uri;
    }

    public SSLContext sslContext() {
        SSLContext sslContext = this.configuration.sslContext();
        return this.isHttps() ? sslContext : null;
    }

    public boolean isHttps() {
        return "HTTPS".equalsIgnoreCase(this.configuration.protocol());
    }

    public boolean autoStart() {
        boolean autoStart = Optional.ofNullable((Boolean)this.configuration.property("jersey.config.server.webserver.autostart")).orElse(Boolean.TRUE);
        return autoStart;
    }

    public static JerseySeBootstrapConfiguration from(SeBootstrap.Configuration configuration) {
        return JerseySeBootstrapConfiguration.class.isInstance(configuration) ? (JerseySeBootstrapConfiguration)configuration : new JerseySeBootstrapConfiguration(configuration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SeBootstrap.Configuration.Builder {
        private static final Map<String, Class<?>> PROPERTY_TYPES = new HashMap();
        private final Map<String, Object> properties = new HashMap<String, Object>();

        private Builder() {
            this.properties.put("jakarta.ws.rs.SeBootstrap.Protocol", "HTTP");
            this.properties.put("jakarta.ws.rs.SeBootstrap.Host", "localhost");
            this.properties.put("jakarta.ws.rs.SeBootstrap.Port", -1);
            this.properties.put("jakarta.ws.rs.SeBootstrap.RootPath", "/");
            this.properties.put("jersey.config.server.webserver.class", WebServer.class);
            try {
                this.properties.put("jakarta.ws.rs.SeBootstrap.SSLContext", SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            this.properties.put("jakarta.ws.rs.SeBootstrap.SSLClientAuthentication", SeBootstrap.Configuration.SSLClientAuthentication.NONE);
            this.properties.put("jersey.config.server.webserver.autostart", Boolean.TRUE);
        }

        public JerseySeBootstrapConfiguration build() {
            return JerseySeBootstrapConfiguration.from(this.properties::get);
        }

        public Builder property(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder webServerClass(Class<? extends WebServer> webServerClass) {
            return this.property("jersey.config.server.webserver.class", webServerClass);
        }

        public Builder autoStart(Boolean autostart) {
            return this.property("jersey.config.server.webserver.autostart", autostart);
        }

        public <T> Builder from(BiFunction<String, Class<T>, Optional<T>> configProvider) {
            PROPERTY_TYPES.forEach((propertyName, propertyType) -> ((Optional)configProvider.apply((String)propertyName, (Class)propertyType)).ifPresent(propertyValue -> this.properties.put((String)propertyName, propertyValue)));
            return this;
        }

        public Builder from(Object externalConfig) {
            if (SeBootstrap.Configuration.class.isInstance(externalConfig)) {
                SeBootstrap.Configuration other = (SeBootstrap.Configuration)externalConfig;
                this.from((T name, U clazz) -> {
                    Object property = other.property(name);
                    if (property != null) {
                        if (clazz.equals(property.getClass())) {
                            return Optional.of(property);
                        }
                        LOGGER.warning(LocalizationMessages.IGNORE_SEBOOTSTRAP_CONFIGURATION_PROPERTY(name, clazz));
                    }
                    return Optional.empty();
                });
            }
            return this;
        }

        static {
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.Protocol", String.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.Host", String.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.Port", Integer.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.RootPath", String.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.SSLContext", SSLContext.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.SSLClientAuthentication", SeBootstrap.Configuration.SSLClientAuthentication.class);
            PROPERTY_TYPES.put("jersey.config.server.webserver.class", Class.class);
            PROPERTY_TYPES.put("jersey.config.server.webserver.autostart", Boolean.class);
        }
    }
}

