/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.beanvalidation.webapp.domain;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;

@XmlRootElement
public class ContactCard {
    @DecimalMin(value="1")
    private Long id;
    @NotNull(message="{contact.wrong.name}")
    @Length(min=2, max=20)
    private String fullName;
    @Email(message="{contact.wrong.email}", regexp="[a-zA-Z0-9._%-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}")
    private String email;
    @Pattern(message="{contact.wrong.phone}", regexp="[0-9]{3,9}")
    private String phone;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContactCard)) {
            return false;
        }
        ContactCard that = (ContactCard)o;
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(that.fullName) : that.fullName != null) {
            return false;
        }
        return !(this.phone != null ? !this.phone.equals(that.phone) : that.phone != null);
    }

    public int hashCode() {
        int result = this.fullName != null ? this.fullName.hashCode() : 0;
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        return result;
    }
}

