/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.beanvalidation.webapp.resource;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.examples.beanvalidation.webapp.constraint.NotEmptySearchField;
import org.glassfish.jersey.examples.beanvalidation.webapp.constraint.SearchType;
import org.glassfish.jersey.examples.beanvalidation.webapp.domain.ContactCard;
import org.glassfish.jersey.examples.beanvalidation.webapp.service.StorageService;
import org.hibernate.validator.constraints.NotBlank;

@Produces(value={"application/json"})
public class SearchResource {
    @SearchType
    @PathParam(value="searchType")
    private String searchType;

    @GET
    @NotNull
    @NotEmptySearchField
    public List<ContactCard> searchForContact(@NotBlank(message="{search.string.empty}") @QueryParam(value="q") String searchValue) {
        if ("email".equals(this.searchType)) {
            return StorageService.findByEmail((String)searchValue);
        }
        if ("phone".equals(this.searchType)) {
            return StorageService.findByPhone((String)searchValue);
        }
        return StorageService.findByName((String)searchValue);
    }
}

