/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.beanvalidation.webapp.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.jersey.examples.beanvalidation.webapp.domain.ContactCard;

public class StorageService {
    private static final AtomicLong contactCounter = new AtomicLong(0L);
    private static final Map<Long, ContactCard> contacts = new HashMap();

    public static ContactCard addContact(ContactCard contact) {
        if (contacts.containsValue(contact)) {
            return null;
        }
        contact.setId(Long.valueOf(contactCounter.incrementAndGet()));
        contacts.put(contact.getId(), contact);
        return contact;
    }

    public static List<ContactCard> clear() {
        Collection values = contacts.values();
        contacts.clear();
        return new ArrayList<ContactCard>(values);
    }

    public static ContactCard remove(Long id) {
        return (ContactCard)contacts.remove(id);
    }

    public static ContactCard get(Long id) {
        return (ContactCard)contacts.get(id);
    }

    public static List<ContactCard> findByEmail(String emailPart) {
        ArrayList<ContactCard> results = new ArrayList<ContactCard>();
        for (ContactCard contactCard : contacts.values()) {
            String email = contactCard.getEmail();
            if (email == null || !email.contains(emailPart)) continue;
            results.add(contactCard);
        }
        return results;
    }

    public static List<ContactCard> findByName(String namePart) {
        ArrayList<ContactCard> results = new ArrayList<ContactCard>();
        for (ContactCard contactCard : contacts.values()) {
            if (!contactCard.getFullName().contains(namePart)) continue;
            results.add(contactCard);
        }
        return results;
    }

    public static List<ContactCard> findByPhone(String phonePart) {
        ArrayList<ContactCard> results = new ArrayList<ContactCard>();
        for (ContactCard contactCard : contacts.values()) {
            String phone = contactCard.getPhone();
            if (phone == null || !phone.contains(phonePart)) continue;
            results.add(contactCard);
        }
        return results;
    }
}

