/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.beanvalidation.webapp.resource;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.examples.beanvalidation.webapp.constraint.AtLeastOneContact;
import org.glassfish.jersey.examples.beanvalidation.webapp.constraint.HasId;
import org.glassfish.jersey.examples.beanvalidation.webapp.domain.ContactCard;
import org.glassfish.jersey.examples.beanvalidation.webapp.resource.SearchResource;
import org.glassfish.jersey.examples.beanvalidation.webapp.service.StorageService;

@Path(value="contact")
@Produces(value={"application/json"})
public class ContactCardResource {
    @Context
    @NotNull
    private ResourceContext resourceContext;

    @POST
    @Consumes(value={"application/json"})
    @NotNull(message="{contact.already.exist}")
    @HasId
    public ContactCard addContact(@NotNull @AtLeastOneContact(message="{contact.empty.means}") @Valid ContactCard contact) {
        return StorageService.addContact((ContactCard)contact);
    }

    @GET
    @NotNull
    @HasId
    public List<ContactCard> getContacts() {
        return StorageService.findByName((String)"");
    }

    @GET
    @Path(value="{id}")
    @NotNull(message="{contact.does.not.exist}")
    @HasId
    public ContactCard getContact(@DecimalMin(value="0", message="{contact.wrong.id}") @PathParam(value="id") Long id) {
        return StorageService.get((Long)id);
    }

    @DELETE
    @NotNull
    @HasId
    public List<ContactCard> deleteContacts() {
        return StorageService.clear();
    }

    @DELETE
    @Path(value="{id}")
    @NotNull(message="{contact.does.not.exist}")
    @HasId
    public ContactCard deleteContact(@DecimalMin(value="0", message="{contact.wrong.id}") @PathParam(value="id") Long id) {
        return StorageService.remove((Long)id);
    }

    @Path(value="search/{searchType}")
    public SearchResource search() {
        return (SearchResource)this.resourceContext.getResource(SearchResource.class);
    }
}

