/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.bookmark_em.resource;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.examples.bookmark_em.entity.BookmarkEntity;
import org.glassfish.jersey.examples.bookmark_em.entity.BookmarkEntityPK;
import org.glassfish.jersey.examples.bookmark_em.entity.UserEntity;
import org.glassfish.jersey.examples.bookmark_em.exception.NotFoundException;
import org.glassfish.jersey.examples.bookmark_em.util.tx.TransactionManager;
import org.glassfish.jersey.examples.bookmark_em.util.tx.Transactional;

public class BookmarkResource {
    UriInfo uriInfo;
    EntityManager em;
    UserTransaction utx;
    BookmarkEntity bookmarkEntity;

    public BookmarkResource(UriInfo uriInfo, EntityManager em, UserTransaction utx, UserEntity userEntity, String bmid) {
        this.uriInfo = uriInfo;
        this.em = em;
        this.utx = utx;
        this.bookmarkEntity = (BookmarkEntity)em.find(BookmarkEntity.class, (Object)new BookmarkEntityPK(bmid, userEntity.getUserid()));
        if (null == this.bookmarkEntity) {
            throw new NotFoundException("bookmark with userid=" + userEntity.getUserid() + " and bmid=" + bmid + " not found\n");
        }
        this.bookmarkEntity.setUserEntity(userEntity);
    }

    @GET
    @Produces(value={"application/json"})
    public JSONObject getBookmark() {
        return this.asJson();
    }

    @PUT
    @Consumes(value={"application/json"})
    public void putBookmark(JSONObject jsonEntity) throws JSONException {
        this.bookmarkEntity.setLdesc(jsonEntity.getString("ldesc"));
        this.bookmarkEntity.setSdesc(jsonEntity.getString("sdesc"));
        this.bookmarkEntity.setUpdated(new Date());
        TransactionManager.manage((UserTransaction)this.utx, (Transactional)new /* Unavailable Anonymous Inner Class!! */);
    }

    @DELETE
    public void deleteBookmark() {
        TransactionManager.manage((UserTransaction)this.utx, (Transactional)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String asString() {
        return this.toString();
    }

    public JSONObject asJson() {
        try {
            return new JSONObject().put("userid", (Object)this.bookmarkEntity.getBookmarkEntityPK().getUserid()).put("sdesc", (Object)this.bookmarkEntity.getSdesc()).put("ldesc", (Object)this.bookmarkEntity.getLdesc()).put("uri", (Object)this.bookmarkEntity.getUri());
        }
        catch (JSONException je) {
            return null;
        }
    }

    public String toString() {
        return this.bookmarkEntity.getBookmarkEntityPK().getUserid();
    }
}

