/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.bookmark_em.resource;

import java.net.URI;
import java.util.List;
import javax.annotation.ManagedBean;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.UserTransaction;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONArray;
import org.glassfish.jersey.examples.bookmark_em.entity.UserEntity;
import org.glassfish.jersey.examples.bookmark_em.resource.UserResource;

@Path(value="/users/")
@ManagedBean
public class UsersResource {
    @PersistenceContext(unitName="BookmarkPU")
    private EntityManager em;
    @Resource
    private UserTransaction utx;
    @Context
    UriInfo uriInfo;

    public List<UserEntity> getUsers() {
        return this.em.createQuery("SELECT u from UserEntity u").getResultList();
    }

    @Path(value="{userid}/")
    public UserResource getUser(@PathParam(value="userid") String userid) {
        return new UserResource(this.uriInfo, this.em, this.utx, userid);
    }

    @GET
    @Produces(value={"application/json"})
    public JSONArray getUsersAsJsonArray() {
        JSONArray uriArray = new JSONArray();
        for (UserEntity userEntity : this.getUsers()) {
            UriBuilder ub = this.uriInfo.getAbsolutePathBuilder();
            URI userUri = ub.path(userEntity.getUserid()).build(new Object[0]);
            uriArray.put((Object)userUri.toASCIIString());
        }
        return uriArray;
    }
}

