/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.bookmark_em.entity;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.ManagedBean;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.glassfish.jersey.examples.bookmark_em.entity.BookmarkEntityPK;
import org.glassfish.jersey.examples.bookmark_em.entity.UserEntity;

@Entity
@Table(name="BOOKMARKS")
@NamedQueries(value={@NamedQuery(name="BookmarkEntity.findByUserid", query="SELECT b FROM BookmarkEntity b WHERE b.bookmarkEntityPK.userid = :userid"), @NamedQuery(name="BookmarkEntity.findByBmid", query="SELECT b FROM BookmarkEntity b WHERE b.bookmarkEntityPK.bmid = :bmid"), @NamedQuery(name="BookmarkEntity.findByUri", query="SELECT b FROM BookmarkEntity b WHERE b.uri = :uri"), @NamedQuery(name="BookmarkEntity.findByUpdated", query="SELECT b FROM BookmarkEntity b WHERE b.updated = :updated"), @NamedQuery(name="BookmarkEntity.findByLdesc", query="SELECT b FROM BookmarkEntity b WHERE b.ldesc = :ldesc"), @NamedQuery(name="BookmarkEntity.findBySdesc", query="SELECT b FROM BookmarkEntity b WHERE b.sdesc = :sdesc")})
@ManagedBean
public class BookmarkEntity
implements Serializable {
    @EmbeddedId
    protected BookmarkEntityPK bookmarkEntityPK;
    @Column(name="URI", nullable=false)
    private String uri;
    @Column(name="UPDATED")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updated;
    @Column(name="LDESC")
    private String ldesc;
    @Column(name="SDESC")
    private String sdesc;
    @JoinColumn(name="USERID", referencedColumnName="USERID", insertable=false, updatable=false)
    @ManyToOne
    private UserEntity userEntity;

    public BookmarkEntity() {
    }

    public BookmarkEntity(BookmarkEntityPK bookmarkEntityPK) {
        this.bookmarkEntityPK = bookmarkEntityPK;
    }

    public BookmarkEntity(BookmarkEntityPK bookmarkEntityPK, String uri) {
        this.bookmarkEntityPK = bookmarkEntityPK;
        this.uri = uri;
    }

    public BookmarkEntity(String bmid, String userid) {
        this.bookmarkEntityPK = new BookmarkEntityPK(bmid, userid);
    }

    public BookmarkEntityPK getBookmarkEntityPK() {
        return this.bookmarkEntityPK;
    }

    public void setBookmarkEntityPK(BookmarkEntityPK bookmarkEntityPK) {
        this.bookmarkEntityPK = bookmarkEntityPK;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public String getLdesc() {
        return this.ldesc;
    }

    public void setLdesc(String ldesc) {
        this.ldesc = ldesc;
    }

    public String getSdesc() {
        return this.sdesc;
    }

    public void setSdesc(String sdesc) {
        this.sdesc = sdesc;
    }

    public UserEntity getUserEntity() {
        return this.userEntity;
    }

    public void setUserEntity(UserEntity userEntity) {
        this.userEntity = userEntity;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.bookmarkEntityPK != null ? this.bookmarkEntityPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BookmarkEntity)) {
            return false;
        }
        BookmarkEntity other = (BookmarkEntity)object;
        return this.bookmarkEntityPK == other.bookmarkEntityPK || this.bookmarkEntityPK != null && this.bookmarkEntityPK.equals((Object)other.bookmarkEntityPK);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("bookmarkEntityPK", (Object)this.bookmarkEntityPK).toString();
    }
}

