/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.bookmark_em.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.examples.bookmark_em.entity.BookmarkEntity;
import org.glassfish.jersey.examples.bookmark_em.resource.BookmarkResource;
import org.glassfish.jersey.examples.bookmark_em.resource.UserResource;
import org.glassfish.jersey.examples.bookmark_em.util.tx.TransactionManager;
import org.glassfish.jersey.examples.bookmark_em.util.tx.Transactional;

public class BookmarksResource {
    UriInfo uriInfo;
    EntityManager em;
    UserTransaction utx;
    UserResource userResource;

    public BookmarksResource(UriInfo uriInfo, EntityManager em, UserTransaction utx, UserResource userResource) {
        this.uriInfo = uriInfo;
        this.em = em;
        this.utx = utx;
        this.userResource = userResource;
    }

    public Collection<BookmarkEntity> getBookmarks() {
        return this.userResource.getUserEntity().getBookmarkEntityCollection();
    }

    @Path(value="{bmid: .+}")
    public BookmarkResource getBookmark(@PathParam(value="bmid") String bmid) {
        return new BookmarkResource(this.uriInfo, this.em, this.utx, this.userResource.getUserEntity(), bmid);
    }

    @GET
    @Produces(value={"application/json"})
    public JSONArray getBookmarksAsJsonArray() {
        JSONArray uriArray = new JSONArray();
        for (BookmarkEntity bookmarkEntity : this.getBookmarks()) {
            UriBuilder ub = this.uriInfo.getAbsolutePathBuilder();
            URI bookmarkUri = ub.path(bookmarkEntity.getBookmarkEntityPK().getBmid()).build(new Object[0]);
            uriArray.put((Object)bookmarkUri.toASCIIString());
        }
        return uriArray;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response postForm(JSONObject bookmark) throws JSONException {
        BookmarkEntity bookmarkEntity = new BookmarkEntity(this.getBookmarkId(bookmark.getString("uri")), this.userResource.getUserEntity().getUserid());
        bookmarkEntity.setUri(bookmark.getString("uri"));
        bookmarkEntity.setUpdated(new Date());
        bookmarkEntity.setSdesc(bookmark.getString("sdesc"));
        bookmarkEntity.setLdesc(bookmark.getString("ldesc"));
        this.userResource.getUserEntity().getBookmarkEntityCollection().add(bookmarkEntity);
        TransactionManager.manage((UserTransaction)this.utx, (Transactional)new /* Unavailable Anonymous Inner Class!! */);
        URI bookmarkUri = this.uriInfo.getAbsolutePathBuilder().path(bookmarkEntity.getBookmarkEntityPK().getBmid()).build(new Object[0]);
        return Response.created((URI)bookmarkUri).build();
    }

    private String getBookmarkId(String uri) {
        return uri;
    }
}

