/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.bookmark_em.resource;

import jakarta.persistence.EntityManager;
import jakarta.transaction.UserTransaction;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.examples.bookmark_em.entity.UserEntity;
import org.glassfish.jersey.examples.bookmark_em.exception.ExtendedNotFoundException;
import org.glassfish.jersey.examples.bookmark_em.resource.BookmarksResource;
import org.glassfish.jersey.examples.bookmark_em.util.tx.TransactionManager;
import org.glassfish.jersey.examples.bookmark_em.util.tx.Transactional;

public class UserResource {
    String userid;
    UserEntity userEntity;
    UriInfo uriInfo;
    EntityManager em;
    UserTransaction utx;

    public UserResource(UriInfo uriInfo, EntityManager em, UserTransaction utx, String userid) {
        this.uriInfo = uriInfo;
        this.userid = userid;
        this.em = em;
        this.utx = utx;
        this.userEntity = (UserEntity)em.find(UserEntity.class, (Object)userid);
    }

    @Path(value="bookmarks/")
    public BookmarksResource getBookmarksResource() {
        if (null == this.userEntity) {
            throw new ExtendedNotFoundException("userid " + this.userid + " does not exist!");
        }
        return new BookmarksResource(this.uriInfo, this.em, this.utx, this);
    }

    @GET
    @Produces(value={"application/json"})
    public JSONObject getUser() throws JSONException {
        if (null == this.userEntity) {
            throw new ExtendedNotFoundException("userid " + this.userid + "does not exist!");
        }
        return new JSONObject().put("userid", (Object)this.userEntity.getUserid()).put("username", (Object)this.userEntity.getUsername()).put("email", (Object)this.userEntity.getEmail()).put("password", (Object)this.userEntity.getPassword()).put("bookmarks", (Object)this.uriInfo.getAbsolutePathBuilder().path("bookmarks").build(new Object[0]));
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response putUser(JSONObject jsonEntity) throws JSONException {
        boolean newRecord;
        String jsonUserid = jsonEntity.getString("userid");
        if (null != jsonUserid && !jsonUserid.equals(this.userid)) {
            return Response.status((int)409).entity((Object)"userids differ!\n").build();
        }
        boolean bl = newRecord = null == this.userEntity;
        if (newRecord) {
            this.userEntity = new UserEntity();
            this.userEntity.setUserid(this.userid);
        }
        this.userEntity.setUsername(jsonEntity.getString("username"));
        this.userEntity.setEmail(jsonEntity.getString("email"));
        this.userEntity.setPassword(jsonEntity.getString("password"));
        if (newRecord) {
            TransactionManager.manage((UserTransaction)this.utx, (Transactional)new /* Unavailable Anonymous Inner Class!! */);
            return Response.created((URI)this.uriInfo.getAbsolutePath()).build();
        }
        TransactionManager.manage((UserTransaction)this.utx, (Transactional)new /* Unavailable Anonymous Inner Class!! */);
        return Response.noContent().build();
    }

    @DELETE
    public void deleteUser() {
        if (null == this.userEntity) {
            throw new ExtendedNotFoundException("userid " + this.userid + "does not exist!");
        }
        TransactionManager.manage((UserTransaction)this.utx, (Transactional)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String toString() {
        return this.userEntity.getUserid();
    }

    public UserEntity getUserEntity() {
        return this.userEntity;
    }
}

