/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.bookstore.webapp.resource;

import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.jersey.examples.bookstore.webapp.resource.Book;
import org.glassfish.jersey.examples.bookstore.webapp.resource.CD;
import org.glassfish.jersey.examples.bookstore.webapp.resource.Item;
import org.glassfish.jersey.examples.bookstore.webapp.resource.Track;
import org.glassfish.jersey.server.mvc.Template;

@Path(value="/")
@Singleton
@Template
@Produces(value={"text/html"})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Bookstore {
    private final Map<String, Item> items = new TreeMap();
    private String name;

    public Bookstore() {
        this.setName("Czech Bookstore");
        this.getItems().put("1", new Book("Svejk", "Jaroslav Hasek"));
        this.getItems().put("2", new Book("Krakatit", "Karel Capek"));
        this.getItems().put("3", new CD("Ma Vlast 1", "Bedrich Smetana", new Track[]{new Track("Vysehrad", 180), new Track("Vltava", 172), new Track("Sarka", 32)}));
    }

    @Path(value="items/{itemid}/")
    public Item getItem(@PathParam(value="itemid") String itemid) {
        Item i = (Item)this.getItems().get(itemid);
        if (i == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Item, " + itemid + ", is not found")).build());
        }
        return i;
    }

    @GET
    @Produces(value={"application/xml", "text/xml", "application/json"})
    public Bookstore getXml() {
        return this;
    }

    public long getSystemTime() {
        return System.currentTimeMillis();
    }

    public Map<String, Item> getItems() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

