/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.clipboard;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.clipboard.Clipboard;
import org.glassfish.jersey.grizzly2.GrizzlyHttpServerFactory;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.Application;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/base/");
    public static final String ROOT_PATH = "clipboard";

    public static void main(String[] args) {
        try {
            System.out.println("Clipboard Jersey Example App");
            Application app = App.createProgrammaticClipboardApp();
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (Application)app);
            System.out.println(String.format("Application started.\nTry out %s%s\nHit enter to stop it...", BASE_URI, ROOT_PATH));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Application createProgrammaticClipboardApp() {
        Application.Builder appFactory = Application.builder();
        final Clipboard clipboard = new Clipboard();
        appFactory.bind(ROOT_PATH).method(new String[]{"GET"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                String content = clipboard.content();
                if (content.isEmpty()) {
                    return Responses.from((Response.StatusType)Response.Status.NO_CONTENT, (Request)data).build();
                }
                return Responses.from((Response.StatusType)Response.Status.OK, (Request)data).entity((Object)content).build();
            }
        }).method(new String[]{"PUT"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                clipboard.setContent((String)data.readEntity(String.class));
                return Responses.from((Response.StatusType)Response.Status.NO_CONTENT, (Request)data).build();
            }
        }).method(new String[]{"POST"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                String newContent = clipboard.append((String)data.readEntity(String.class));
                return Responses.from((Response.StatusType)Response.Status.OK, (Request)data).entity((Object)newContent).build();
            }
        }).method(new String[]{"DELETE"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                clipboard.clear();
                return Responses.from((Response.StatusType)Response.Status.NO_CONTENT, (Request)data).build();
            }
        });
        return appFactory.build();
    }
}

