/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.clipboard;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.clipboard.Clipboard;
import org.glassfish.jersey.grizzly2.GrizzlyHttpServerFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.ResourceBuilder;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/base/");
    public static final String ROOT_PATH = "clipboard";

    public static void main(String[] args) {
        try {
            System.out.println("Clipboard Jersey Example App");
            ResourceConfig config = App.createProgrammaticClipboardApp();
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)config);
            System.out.println(String.format("Application started.%nTry out %s%s%nHit enter to stop it...", BASE_URI, ROOT_PATH));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig createProgrammaticClipboardApp() {
        ResourceBuilder resourceBuilder = ResourceConfig.resourceBuilder();
        final Clipboard clipboard = new Clipboard();
        resourceBuilder.path(ROOT_PATH).method(new String[]{"GET"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                String content = clipboard.content();
                if (content.isEmpty()) {
                    return Response.noContent().build();
                }
                return Response.ok((Object)content).build();
            }
        }).method(new String[]{"PUT"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                if (data != null) {
                    clipboard.setContent((String)data.readEntity(String.class));
                }
                return Response.noContent().build();
            }
        }).method(new String[]{"POST"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                String newContent = data != null ? clipboard.append((String)data.readEntity(String.class)) : "";
                return Response.ok((Object)newContent).build();
            }
        }).method(new String[]{"DELETE"}).to((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request data) {
                clipboard.clear();
                return Response.noContent().build();
            }
        });
        return new ResourceConfig().addResources(resourceBuilder.build());
    }
}

