/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.clipboard;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.clipboard.Clipboard;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/base/");
    public static final String ROOT_PATH = "clipboard";

    public static void main(String[] args) {
        try {
            System.out.println("Clipboard Jersey Example App");
            ResourceConfig config = App.createProgrammaticClipboardApp();
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)config);
            System.out.println(String.format("Application started.%nTry out %s%s%nHit enter to stop it...", BASE_URI, ROOT_PATH));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig createProgrammaticClipboardApp() {
        Resource.Builder resourceBuilder = Resource.builder((String)ROOT_PATH);
        final Clipboard clipboard = new Clipboard();
        resourceBuilder.addMethod("GET").handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext data) {
                String content = clipboard.content();
                if (content.isEmpty()) {
                    return Response.noContent().build();
                }
                return Response.ok((Object)content).build();
            }
        });
        resourceBuilder.addMethod("PUT").handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext data) {
                if (data != null) {
                    clipboard.setContent((String)((ContainerRequest)data).readEntity(String.class));
                }
                return Response.noContent().build();
            }
        });
        resourceBuilder.addMethod("POST").handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext data) {
                String newContent = data != null ? clipboard.append((String)((ContainerRequest)data).readEntity(String.class)) : "";
                return Response.ok((Object)newContent).build();
            }
        });
        resourceBuilder.addMethod("DELETE").handledBy((Inflector)new Inflector<ContainerRequestContext, Response>(){

            public Response apply(ContainerRequestContext data) {
                clipboard.clear();
                return Response.noContent().build();
            }
        });
        return new ResourceConfig().addResources(new Resource[]{resourceBuilder.build()});
    }
}

