/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.clipboard;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.examples.clipboard.ClipboardData;

@Path(value="clipboard")
public class ClipboardResource {
    private static final List<String> history = new LinkedList<String>();
    private static ClipboardData content = new ClipboardData("");

    @GET
    @Produces(value={"text/plain", "application/json"})
    public Response content() {
        if (content.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)content, (String)"text/plain").build();
    }

    @PUT
    @Consumes(value={"text/plain", "application/json"})
    public void setContent(ClipboardData newContent) {
        this.saveHistory();
        content = newContent;
    }

    @POST
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"text/plain", "application/json"})
    public ClipboardData append(ClipboardData appendix) {
        this.saveHistory();
        return content.append(appendix);
    }

    @DELETE
    public void clear() {
        this.saveHistory();
        content.clear();
    }

    @GET
    @Path(value="history")
    @Produces(value={"text/plain", "application/json"})
    public List<String> getHistory() {
        return history;
    }

    @DELETE
    @Path(value="history")
    public void clearHistory() {
        history.clear();
    }

    private void saveHistory() {
        String currentContent = content.toString();
        if (!currentContent.isEmpty()) {
            history.add(currentContent);
        }
    }
}

