/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.clipboard;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.examples.clipboard.ClipboardData;
import org.glassfish.jersey.examples.clipboard.ClipboardDataProvider;
import org.glassfish.jersey.examples.clipboard.ClipboardResource;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;

public class App {
    private static final URI BASE_URI = URI.create("http://localhost:8080/base/");
    public static final String ROOT_PATH = "clipboard";

    public static void main(String[] args) {
        try {
            System.out.println("Clipboard Jersey Example App");
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)BASE_URI, (ResourceConfig)App.createApp());
            System.out.println(String.format("Application started.%nTry out %s%s%nHit enter to stop it...", BASE_URI, ROOT_PATH));
            System.in.read();
            server.stop();
        }
        catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ResourceConfig createApp() {
        MediaType[] jsonAndTextTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_PLAIN_TYPE};
        ResourceConfig resourceConfig = new ResourceConfig(new Class[]{ClipboardResource.class, ClipboardDataProvider.ApplicationJson.class, ClipboardDataProvider.TextPlain.class});
        Resource.Builder resourceBuilder = Resource.builder((String)"echo");
        ResourceMethod.Builder rmBuilder = resourceBuilder.addMethod("POST");
        rmBuilder.consumes(jsonAndTextTypes).produces(jsonAndTextTypes).handledBy((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request request) {
                ClipboardData data = request != null ? (ClipboardData)((JerseyContainerRequestContext)request).readEntity(ClipboardData.class) : null;
                return Response.ok(data).build();
            }
        });
        resourceConfig.addResources(new Resource[]{resourceBuilder.build()});
        return resourceConfig;
    }
}

