/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.clipboard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.examples.clipboard.ClipboardData;
import org.glassfish.jersey.message.MessageUtils;

public abstract class ClipboardDataProvider
implements MessageBodyWriter,
MessageBodyReader {
    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isKnownType(type, genericType);
    }

    private boolean isKnownType(Class<?> type, Type genericType) {
        return type.isAssignableFrom(ClipboardData.class) || Collection.class.isAssignableFrom(type) && ((ParameterizedType)genericType).getActualTypeArguments()[0].equals(String.class);
    }

    public long getSize(Object t, Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isKnownType(type, genericType);
    }

    private static String readStringFromStream(InputStream entityStream, Charset charset) throws IOException {
        int i;
        StringBuilder result = new StringBuilder();
        byte[] buf = new byte[2048];
        while ((i = entityStream.read(buf)) != -1) {
            result.append(new String(buf, 0, i, charset));
        }
        return result.toString();
    }

    @Provider
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public static class ApplicationJson
    extends ClipboardDataProvider {
        private static final String JsonOpenning = "{\"content\":\"";
        private static final String JsonClosing = "\"}";

        public void writeTo(Object t, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(String.format("%s%s%s", JsonOpenning, t.toString(), JsonClosing).getBytes(MessageUtils.getCharset((MediaType)mediaType)));
        }

        public Object readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            String jsonExpression = ClipboardDataProvider.readStringFromStream(entityStream, MessageUtils.getCharset((MediaType)mediaType));
            return new ClipboardData(jsonExpression.replace(JsonOpenning, "").replace(JsonClosing, ""));
        }
    }

    @Provider
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public static class TextPlain
    extends ClipboardDataProvider {
        public void writeTo(Object t, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(t.toString().getBytes(MessageUtils.getCharset((MediaType)mediaType)));
        }

        public Object readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return new ClipboardData(ClipboardDataProvider.readStringFromStream(entityStream, MessageUtils.getCharset((MediaType)mediaType)));
        }
    }
}

