/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.linking.representation;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Link;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.glassfish.jersey.examples.linking.model.ItemsModel;
import org.glassfish.jersey.examples.linking.representation.ItemRepresentation;
import org.glassfish.jersey.examples.linking.resources.ItemsResource;
import org.glassfish.jersey.linking.Binding;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinks;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="items")
@InjectLinks(value={@InjectLink(resource=ItemsResource.class, style=InjectLink.Style.ABSOLUTE, method="query", condition="${instance.offset + instance.limit < instance.modelLimit}", bindings={@Binding(name="offset", value="${instance.offset + instance.limit}"), @Binding(name="limit", value="${instance.limit}")}, rel="next"), @InjectLink(resource=ItemsResource.class, style=InjectLink.Style.ABSOLUTE, method="query", condition="${instance.offset - instance.limit >= 0}", bindings={@Binding(name="offset", value="${instance.offset - instance.limit}"), @Binding(name="limit", value="${instance.limit}")}, rel="prev")})
public class ItemsRepresentation {
    @XmlElement(name="items")
    private List<ItemRepresentation> items;
    @XmlTransient
    private int offset;
    @XmlTransient
    private int limit;
    @XmlTransient
    private ItemsModel itemsModel;
    @InjectLink(resource=ItemsResource.class, method="query", style=InjectLink.Style.ABSOLUTE, bindings={@Binding(name="offset", value="${instance.offset}"), @Binding(name="limit", value="${instance.limit}")}, rel="self")
    @XmlJavaTypeAdapter(value=Link.JaxbAdapter.class)
    @XmlElement(name="link")
    Link self;
    @InjectLinks(value={@InjectLink(resource=ItemsResource.class, style=InjectLink.Style.ABSOLUTE, method="query", condition="${instance.offset + instance.limit < instance.modelLimit}", bindings={@Binding(name="offset", value="${instance.offset + instance.limit}"), @Binding(name="limit", value="${instance.limit}")}, rel="next"), @InjectLink(resource=ItemsResource.class, style=InjectLink.Style.ABSOLUTE, method="query", condition="${instance.offset - instance.limit >= 0}", bindings={@Binding(name="offset", value="${instance.offset - instance.limit}"), @Binding(name="limit", value="${instance.limit}")}, rel="prev")})
    @XmlElement(name="link")
    @XmlElementWrapper(name="links")
    @XmlJavaTypeAdapter(value=Link.JaxbAdapter.class)
    List<Link> links;

    public ItemsRepresentation() {
        this.offset = 0;
        this.limit = 10;
    }

    public ItemsRepresentation(ItemsModel itemsModel, int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        this.itemsModel = itemsModel;
        this.items = new ArrayList<ItemRepresentation>();
        for (int i = offset; i < offset + limit && i < itemsModel.getSize(); ++i) {
            this.items.add(new ItemRepresentation(itemsModel, Integer.toString(i), itemsModel.getItem(Integer.toString(i)).getName()));
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getModelLimit() {
        return this.itemsModel.getSize();
    }
}

