/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.linking.resources;

import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.glassfish.jersey.examples.linking.model.ItemModel;
import org.glassfish.jersey.examples.linking.model.ItemsModel;
import org.glassfish.jersey.examples.linking.representation.ItemRepresentation;

@Path(value="items/{id}")
@Produces(value={"application/xml", "application/json"})
public class ItemResource {
    private ItemsModel itemsModel;
    private ItemModel itemModel;
    private String id;

    public ItemResource(@PathParam(value="id") String id) {
        this.id = id;
        this.itemsModel = ItemsModel.getInstance();
        try {
            this.itemModel = this.itemsModel.getItem(id);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new NotFoundException();
        }
    }

    @GET
    public ItemRepresentation get() {
        return new ItemRepresentation(this.itemModel.getName());
    }

    public boolean isNext() {
        return this.itemsModel.hasNext(this.id);
    }

    public boolean isPrev() {
        return this.itemsModel.hasPrev(this.id);
    }

    public String getNextId() {
        return this.itemsModel.getNextId(this.id);
    }

    public String getPrevId() {
        return this.itemsModel.getPrevId(this.id);
    }

    public String getId() {
        return this.id;
    }
}

