/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.exception;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.examples.exception.Exceptions;
import org.glassfish.jersey.server.ContainerRequest;

@Path(value="exception")
public class ExceptionResource {
    @GET
    @Produces(value={"text/plain"})
    public String pingMe() {
        return "ping!";
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="webapplication_entity")
    public String testWebApplicationExceptionEntity(String s) {
        String[] tokens = s.split(":");
        assert (tokens.length == 2);
        int statusCode = Integer.valueOf(tokens[1]);
        Response r = Response.status((int)statusCode).entity((Object)s).build();
        throw new WebApplicationException(r);
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="webapplication_noentity")
    public String testWebApplicationExceptionNoEntity(String s) {
        String[] tokens = s.split(":");
        assert (tokens.length == 2);
        int statusCode = Integer.valueOf(tokens[1]);
        Response r = Response.status((int)statusCode).build();
        throw new WebApplicationException(r);
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="my")
    public String testMyException(String s) {
        String[] tokens = s.split(":");
        assert (tokens.length == 2);
        int statusCode = Integer.valueOf(tokens[1]);
        Response r = Response.status((int)statusCode).build();
        throw new Exceptions.MyException(r);
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="mysub")
    public String testMySubException(String s) {
        String[] tokens = s.split(":");
        assert (tokens.length == 2);
        int statusCode = Integer.valueOf(tokens[1]);
        Response r = Response.status((int)statusCode).build();
        throw new Exceptions.MySubException(r);
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="mysubsub")
    public String testMySubSubException(String s) {
        String[] tokens = s.split(":");
        assert (tokens.length == 2);
        int statusCode = Integer.valueOf(tokens[1]);
        Response r = Response.status((int)statusCode).build();
        throw new Exceptions.MySubSubException(r);
    }

    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="request_exception")
    public String exceptionInRequestFilter() {
        throw new InternalServerErrorException();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="response_exception")
    public String exceptionInResponseFilter() {
        return "response_exception";
    }

    @Provider
    static class WebApplicationExceptionFilter
    implements ContainerRequestFilter,
    ContainerResponseFilter {
        WebApplicationExceptionFilter() {
        }

        public void filter(ContainerRequestContext context) throws IOException {
            System.out.println("WebApplicationExceptionFilter.preFilter() enter");
            if (context.hasEntity() && ((String)((ContainerRequest)context).readEntity(String.class)).equals("Request Exception")) {
                throw new WebApplicationException(Response.Status.OK);
            }
            System.out.println("WebApplicationExceptionFilter.preFilter() exit");
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            System.out.println("WebApplicationExceptionFilter.postFilter() enter");
            if (responseContext.hasEntity() && responseContext.getEntity().equals("Response Exception")) {
                throw new WebApplicationException(Response.Status.OK);
            }
            System.out.println("WebApplicationExceptionFilter.postFilter() exit");
        }
    }

    @Provider
    static class MyResponseFilter
    implements ContainerResponseFilter {
        MyResponseFilter() {
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            System.out.println("MyResponseFilter.postFilter() enter");
            responseContext.setEntity((Object)(responseContext.getEntity() + ":" + this.getClass().getSimpleName()), null, MediaType.TEXT_PLAIN_TYPE);
            System.out.println("MyResponseFilter.postFilter() exit");
        }
    }
}

