/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.extendedwadl.resources;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.examples.extendedwadl.Item;
import org.glassfish.jersey.examples.extendedwadl.resources.ItemResource;

@Singleton
@Path(value="items")
public class ItemsResource {
    @Context
    UriInfo _uriInfo;
    private final AtomicInteger _sequence = new AtomicInteger();
    private final Map<Integer, Item> _repository = new HashMap();

    @Path(value="{id}")
    public ItemResource getItem(@PathParam(value="id") Integer id) {
        Item item = (Item)this._repository.get(id);
        if (item == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Item with id " + id + " does not " + "exist!")).build());
        }
        return new ItemResource(item);
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response createItem(Item item) {
        Integer id = this._sequence.incrementAndGet();
        this._repository.put(id, item);
        return Response.created((URI)this._uriInfo.getAbsolutePathBuilder().clone().path(id.toString()).build(new Object[0])).build();
    }
}

