/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.extendedwadl.resources;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.glassfish.jersey.examples.extendedwadl.Item;

public class ItemResource {
    private final Item _item;

    public ItemResource(Item item) {
        this._item = item;
    }

    @GET
    @Produces(value={"application/xml", "text/plain"})
    public Response getItem() {
        if (System.currentTimeMillis() % 2L == 0L) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Sorry, but right now we can't process this request, try again an odd number of milliseconds later, please :)").type("text/plain").build();
        }
        return Response.ok((Object)this._item).build();
    }

    @GET
    @Produces(value={"application/xml", "text/plain"})
    @Path(value="try-hard")
    public Response getItem(@HeaderParam(value="Try-Hard") boolean tryHard) {
        if (!tryHard) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Sorry, but right now we can't process this request, try again and set the \"Try-Hard\" header to \"true\"").type("text/plain").build();
        }
        return Response.ok((Object)this._item).build();
    }

    @GET
    @Produces(value={"application/json"})
    public JSONArray getItemAsJSON() {
        JSONArray result = new JSONArray();
        result.put((Object)this._item.getValue());
        return result;
    }

    @Path(value="value/{value}")
    @PUT
    @Consumes(value={"application/xml"})
    public void updateItemValue(@PathParam(value="value") String value) {
        this._item.setValue(value);
    }
}

