/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner;

import org.glassfish.jersey.examples.feedcombiner.binder.ApplicationBinder;
import org.glassfish.jersey.examples.feedcombiner.store.ObservableDataStore;
import org.glassfish.jersey.examples.feedcombiner.store.ReadWriteLockDataStore;
import org.glassfish.jersey.moxy.json.MoxyJsonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.beanvalidation.MvcBeanValidationFeature;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.glassfish.jersey.server.validation.ValidationFeature;

public class MyApplication
extends ResourceConfig {
    public static final String PROPS_FILE = "application.properties";

    public MyApplication() {
        this.init((ObservableDataStore)new ReadWriteLockDataStore(), true);
    }

    public MyApplication(ObservableDataStore datastore, boolean activeScheduler) {
        this.init(datastore, activeScheduler);
    }

    private void init(ObservableDataStore datastore, boolean activeScheduler) {
        this.packages(new String[]{MyApplication.class.getPackage().getName()});
        this.property("jersey.config.server.mvc.templateBasePath.freemarker", (Object)"templates");
        this.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true);
        this.register(MoxyJsonFeature.class);
        this.register(ValidationFeature.class);
        this.register(FreemarkerMvcFeature.class);
        this.register(MvcBeanValidationFeature.class);
        this.register((Object)new ApplicationBinder(datastore, PROPS_FILE, activeScheduler));
    }
}

