/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.manager;

import com.sun.syndication.feed.synd.SyndEntry;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.glassfish.jersey.examples.feedcombiner.manager.FeedDownloadTask;
import org.glassfish.jersey.examples.feedcombiner.model.CombinedFeed;
import org.glassfish.jersey.examples.feedcombiner.store.InMemoryDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedDownloadTask
implements Runnable {
    private static Logger LOG = LoggerFactory.getLogger((String)FeedDownloadTask.class.getName());
    private final FeedEntryMapper entryMapper = new FeedEntryMapper(null);
    private final Function<URL, List<SyndEntry>> feedDownloader;
    private final InMemoryDataStore datastore;
    private final String combinedFeedID;

    FeedDownloadTask(Function<URL, List<SyndEntry>> feedDownloader, InMemoryDataStore datastore, String feedId) {
        this.combinedFeedID = feedId;
        this.datastore = datastore;
        this.feedDownloader = feedDownloader;
    }

    @Override
    public void run() {
        CombinedFeed fetchedCombinedFeed = (CombinedFeed)this.datastore.get(this.combinedFeedID, CombinedFeed.class);
        if (fetchedCombinedFeed == null) {
            LOG.warn("There is no CombinedFeed for the ID: " + this.combinedFeedID);
            return;
        }
        List entries = fetchedCombinedFeed.getUrls().stream().map(this.feedDownloader).flatMap(Collection::stream).map(this.entryMapper).filter(Objects::nonNull).sorted((e1, e2) -> e2.getPublishDate().compareTo(e1.getPublishDate())).collect(Collectors.toList());
        CombinedFeed combinedFeed = CombinedFeed.CombinedFeedBuilder.of((CombinedFeed)fetchedCombinedFeed).feedEntries(entries).build();
        this.datastore.put(this.combinedFeedID, (Serializable)combinedFeed);
        LOG.debug("New entries for the CombinedFeed were downloaded [combined-feed={}, entries-count={}]", (Object)combinedFeed.getId(), (Object)entries.size());
    }
}

