/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.jersey.examples.feedcombiner.generator.IdGenerator;
import org.glassfish.jersey.examples.feedcombiner.model.CombinedFeed;
import org.glassfish.jersey.examples.feedcombiner.service.CrudService;
import org.glassfish.jersey.examples.feedcombiner.store.InMemoryDataStore;
import org.glassfish.jersey.examples.feedcombiner.store.ReadWriteLockDataStore;

public class CombinedFeedService
implements CrudService<CombinedFeed> {
    private InMemoryDataStore datastore;
    private IdGenerator idGenerator;
    private String defaultRefreshPeriod;

    @Inject
    public CombinedFeedService(InMemoryDataStore datastore, IdGenerator idGenerator, @Named(value="feed.default-refresh-period") String defaultRefreshPeriod) {
        this.datastore = datastore;
        this.idGenerator = idGenerator;
        this.defaultRefreshPeriod = defaultRefreshPeriod;
    }

    public CombinedFeed save(CombinedFeed insertedFeed) {
        String entityId = this.idGenerator.getId();
        CombinedFeed.CombinedFeedBuilder feedBuilder = CombinedFeed.CombinedFeedBuilder.of((CombinedFeed)insertedFeed).id(entityId).feedEntries(null);
        if (insertedFeed.getRefreshPeriod() == 0L) {
            feedBuilder.refreshPeriod(Long.parseLong(this.defaultRefreshPeriod));
        }
        CombinedFeed combinedFeed = feedBuilder.build();
        this.datastore.put(entityId, (Serializable)combinedFeed);
        return combinedFeed;
    }

    public Serializable delete(String feedId) {
        return this.datastore.put(feedId, null);
    }

    public CombinedFeed update(CombinedFeed feed) {
        throw new UnsupportedOperationException("This operation is not implemented yet.");
    }

    public CombinedFeed get(String feedId) {
        return (CombinedFeed)this.datastore.get(feedId, CombinedFeed.class);
    }

    public List<CombinedFeed> getAll() {
        if (this.datastore instanceof ReadWriteLockDataStore) {
            ReadWriteLockDataStore rwDatastore = (ReadWriteLockDataStore)this.datastore;
            Collection entities = rwDatastore.getAll();
            return entities.parallelStream().filter(entity -> entity instanceof CombinedFeed).map(CombinedFeed.class::cast).collect(Collectors.toList());
        }
        return new ArrayList<CombinedFeed>();
    }
}

