/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.feedcombiner.model;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.glassfish.jersey.examples.feedcombiner.model.FeedEntry;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class CombinedFeed
implements Serializable {
    private static final long serialVersionUID = 2176919801739913480L;
    private static Logger LOG = LoggerFactory.getLogger((String)CombinedFeed.class.getName());
    private String id;
    @NotEmpty(message="At least one valid URL must be in the request.")
    private List<URL> urls;
    @Min(value=0L, message="Refresh period must be equal or higher than 0.")
    private long refreshPeriod;
    private List<FeedEntry> feedEntries;
    @NotNull(message="Title may not be null.")
    private String title;
    @NotNull(message="Description may not be null.")
    private String description;

    private CombinedFeed() {
    }

    private CombinedFeed(String id, List<URL> urls, long refreshPeriod, List<FeedEntry> feedEntries, String title, String description) {
        this.id = id;
        this.urls = urls;
        this.refreshPeriod = refreshPeriod;
        this.feedEntries = feedEntries;
        this.title = title;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public List<URL> getUrls() {
        if (this.urls == null) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        return this.urls;
    }

    public List<FeedEntry> getFeedEntries() {
        if (this.feedEntries == null) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        return this.feedEntries;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CombinedFeed{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", urls=").append(this.urls);
        sb.append(", refreshPeriod=").append(this.refreshPeriod);
        sb.append(", feedEntries=").append(this.feedEntries);
        sb.append(", title='").append(this.title).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CombinedFeed feed = (CombinedFeed)obj;
        return Objects.equals(this.id, feed.id) && Objects.equals(this.title, feed.title) && Objects.equals(this.description, feed.description) && Objects.equals(this.refreshPeriod, feed.refreshPeriod) && Objects.deepEquals(this.urls, feed.urls) && Objects.deepEquals(this.feedEntries, feed.feedEntries);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.description, this.refreshPeriod, this.urls, this.feedEntries);
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }
}

